/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.query.builder;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.persist.Messages;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.ObjectIDFactory;
import com.raplix.rolloutexpress.persist.map.attribute.AssociationAttributeMap;
import com.raplix.rolloutexpress.persist.map.attribute.AttributeMap;
import com.raplix.rolloutexpress.persist.map.attribute.IDAttributeMap;
import com.raplix.rolloutexpress.persist.map.exception.ClassMapException;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import java.sql.ResultSet;
import java.sql.SQLException;

public class IDColumn
extends ColumnNode
implements Messages {
    public static final String ID_COL_NAME = "OBJECTID";
    public static final String ID_ATTR_NAME = "ID";

    public IDColumn(Table inTable, String inAttributeName) {
        super(inTable, inAttributeName);
    }

    public IDColumn(Table inTable) {
        super(inTable, ID_ATTR_NAME);
    }

    public String getColumnName() {
        if (this.getAttributeMap() == null) {
            return ID_COL_NAME;
        }
        return super.getColumnName();
    }

    public ObjectID retrieveValue(ResultSet inResultSet) throws ClassMapException, SQLException {
        AttributeMap aMap = this.getAttributeMap();
        ObjectIDFactory idFactory = null;
        if (aMap == null) {
            idFactory = this.getTable().getClassMap().getIDFactory();
        } else if (aMap instanceof IDAttributeMap) {
            idFactory = ((IDAttributeMap)aMap).getMappedClass().getIDFactory();
        } else if (aMap instanceof AssociationAttributeMap) {
            idFactory = ((AssociationAttributeMap)aMap).getMappedClass().getIDFactory();
        }
        if (idFactory == null) {
            throw new ClassMapException(new ROXMessage("pm.idam.UNKOWN_ATTRIBUTE_MAP", new String[]{aMap.getColumnName()}));
        }
        return IDColumn.getValue(inResultSet, idFactory, this.getSQLColumnName());
    }

    public static ObjectID getValue(ResultSet inResultSet, ObjectIDFactory inFactory, String columnName) throws SQLException {
        return IDAttributeMap.convertFromString(inFactory, inResultSet.getString(columnName));
    }

    public static ObjectID getValue(ResultSet inResultSet, ObjectIDFactory inFactory, int columnIndex) throws SQLException {
        return IDAttributeMap.convertFromString(inFactory, inResultSet.getString(columnIndex));
    }

    private IDColumn() {
    }
}

