/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.query.builder;

import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.query.builder.ColumnAlias;
import com.raplix.rolloutexpress.persist.query.builder.ScalarExp;
import com.raplix.rolloutexpress.persist.query.builder.ScalarList;
import com.raplix.rolloutexpress.persist.query.builder.SelectAlias;
import com.raplix.rolloutexpress.persist.sql.Database;
import com.raplix.rolloutexpress.persist.sql.SQLStatement;

class Function
implements ScalarExp,
ColumnAlias {
    private String mFunctionName;
    private ScalarList mArguments;
    private SelectAlias mSQLAliasName;

    Function(String inFunctionName, ScalarList inArguments) {
        this.mFunctionName = inFunctionName;
        this.mArguments = inArguments;
    }

    Function(String inFunctionName, ScalarList inArguments, SelectAlias inSQLAlias) {
        this(inFunctionName, inArguments);
        this.mSQLAliasName = inSQLAlias;
    }

    protected String getFunctionName() {
        return this.mFunctionName;
    }

    public void writeSQL(SQLStatement stmt) {
        stmt.addSQLClause(this.getFunctionName()).addSQLClause("(");
        this.mArguments.writeSQL(stmt);
        stmt.addSQLClause(")");
    }

    public void writeSQLForSelect(SQLStatement stmt) {
        this.writeSQL(stmt);
        if (this.mSQLAliasName != null) {
            Database db = PersistenceManager.getInstance().getDefaultDatabase();
            stmt.addSQLClause(" ").addSQLClause(db.getClauseStringAS()).addSQLClause(" ");
            this.mSQLAliasName.writeSQL(stmt);
            stmt.addSQLClause(" ");
        }
    }

    protected Function() {
    }
}

