/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.query.builder;

import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.map.attribute.DateAttributeMap;
import com.raplix.rolloutexpress.persist.map.exception.ClassMapException;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.persist.sql.Database;
import com.raplix.rolloutexpress.persist.sql.SQLStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;

public class DateColumn
extends ColumnNode {
    public DateColumn(Table inTable, String inAttributeName) {
        super(inTable, inAttributeName);
    }

    public Date retrieveValue(ResultSet inResultSet) throws ClassMapException, SQLException {
        return DateColumn.getValue(inResultSet, this.getSQLColumnName());
    }

    public static Date getValue(ResultSet inResultSet, String columnName) throws ClassMapException, SQLException {
        return DateAttributeMap.convertFromString(inResultSet.getString(columnName));
    }

    public static Date getValue(ResultSet inResultSet, int columnIndex) throws ClassMapException, SQLException {
        return DateAttributeMap.convertFromString(inResultSet.getString(columnIndex));
    }

    public void writeSQLForSelect(SQLStatement stmt) {
        Database db = PersistenceManager.getInstance().getDefaultDatabase();
        stmt.addSQLClause(db.getTimeStampRetrievalString(this.getAliasedColumnName())).addSQLClause(" ").addSQLClause(db.getClauseStringAS()).addSQLClause(" ");
        stmt.addSQLClause(this.getSQLColumnName()).addSQLClause(" ");
    }

    private DateColumn() {
    }
}

