/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.query.builder;

import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.SqlNode;
import com.raplix.rolloutexpress.persist.sql.SQLStatement;
import java.util.Enumeration;
import java.util.Vector;

public abstract class ConditionalExprList
extends ConditionalExpression {
    private Vector elements = null;

    ConditionalExprList() {
    }

    public ConditionalExprList add(ConditionalExprList inList) {
        Enumeration e = inList.getElements();
        if (e != null) {
            while (e.hasMoreElements()) {
                this.add((ConditionalExpression)e.nextElement());
            }
        }
        return this;
    }

    public ConditionalExprList add(ConditionalExpression inCondExpr) {
        if (this.elements == null) {
            this.elements = new Vector();
        }
        this.elements.add(inCondExpr);
        return this;
    }

    public Enumeration getElements() {
        if (this.elements == null) {
            return null;
        }
        return this.elements.elements();
    }

    public void writeExp(SQLStatement stmt) {
        block1: {
            if (this.elements == null || this.elements.size() <= 0) break block1;
            int i = 0;
            while (true) {
                SqlNode tmpNode = (SqlNode)this.elements.elementAt(i);
                tmpNode.writeSQL(stmt);
                if (++i >= this.elements.size()) break;
                stmt.addSQLClause(" ").addSQLClause(this.getSeparator()).addSQLClause(" ");
            }
            stmt.addSQLClause(" ");
        }
    }

    public boolean contains(ConditionalExpression inCondExpr) {
        if (this.elements != null) {
            return this.elements.contains(inCondExpr);
        }
        return false;
    }

    protected abstract String getSeparator();

    public String toString() {
        return this.getClass().getName() + this.elements;
    }
}

