/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.query.builder;

import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.Parentheses;
import com.raplix.rolloutexpress.persist.query.builder.ScalarExp;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.SqlNode;
import com.raplix.rolloutexpress.persist.query.builder.ValueWrapper;
import com.raplix.rolloutexpress.persist.sql.SQLStatement;

class Comparison
extends ConditionalExpression {
    public static final Operator equals = new Operator("=");
    public static final Operator lessThan = new Operator("<");
    public static final Operator greaterThan = new Operator(">");
    public static final Operator lessEquals = new Operator("<=");
    public static final Operator greaterEquals = new Operator(">=");
    public static final Operator notEquals = new Operator("<>");
    private Operator mOperator;
    private SqlNode left;
    private SqlNode right;

    public Comparison(Operator inOperator, ColumnNode inColumn1, ColumnNode inColumn2) {
        this(inOperator, (SqlNode)inColumn1, (SqlNode)inColumn2);
    }

    public Comparison(Operator inOperator, ColumnNode inColumn, Select inSelect) {
        this(inOperator, (SqlNode)inColumn, new Parentheses(inSelect));
    }

    public Comparison(Operator inOperator, Select inSelect, ScalarExp inScalar) {
        this(inOperator, new Parentheses(inSelect), (SqlNode)inScalar);
    }

    Comparison(Operator inOperator, ColumnNode inLeft, ValueWrapper inRight) {
        this(inOperator, (SqlNode)inLeft, (SqlNode)inRight);
    }

    Comparison(Operator inOperator, SqlNode inLeft, SqlNode inRight) {
        this.mOperator = inOperator;
        this.left = inLeft;
        this.right = inRight;
    }

    protected void writeExp(SQLStatement stmt) {
        this.left.writeSQL(stmt);
        stmt.addSQLClause(this.mOperator.getOperatorString()).addSQLClause(" ");
        this.right.writeSQL(stmt);
    }

    private Comparison() {
    }

    public static final class Operator
    implements RPCSerializable {
        private String operatorString;

        Operator(String inStringOperator) {
            this.operatorString = inStringOperator;
        }

        String getOperatorString() {
            return this.operatorString;
        }

        private Operator() {
        }
    }
}

