/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.query.builder;

import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.map.attribute.AttributeMap;
import com.raplix.rolloutexpress.persist.query.builder.ColumnAlias;
import com.raplix.rolloutexpress.persist.query.builder.ScalarExp;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.persist.sql.Database;
import com.raplix.rolloutexpress.persist.sql.SQLStatement;

public class ColumnNode
implements ScalarExp,
ColumnAlias {
    private Table mTable;
    private String mAttributeName;
    private transient String mSQLColumnName;
    private transient String mAliasedColumnName;
    private transient AttributeMap mAttributeMap;

    public ColumnNode(Table inTable, String inAttributeName) {
        this.mTable = inTable;
        this.mAttributeName = inAttributeName;
    }

    public void writeSQL(SQLStatement stmt) {
        this.mTable.writeColumnPrefix(stmt);
        stmt.addSQLClause(this.getColumnName()).addSQLClause(" ");
    }

    public void writeSQLForSelect(SQLStatement stmt) {
        Database db = PersistenceManager.getInstance().getDefaultDatabase();
        this.mTable.writeColumnPrefix(stmt);
        stmt.addSQLClause(this.getColumnName()).addSQLClause(" ").addSQLClause(db.getClauseStringAS()).addSQLClause(" ");
        stmt.addSQLClause(this.getSQLColumnName()).addSQLClause(" ");
    }

    public String getSQLColumnName() {
        if (this.mSQLColumnName == null) {
            this.mSQLColumnName = this.mTable.getColumnAliasPrefix() + this.getColumnName();
        }
        return this.mSQLColumnName;
    }

    public String getAliasedColumnName() {
        if (this.mAliasedColumnName == null) {
            this.mAliasedColumnName = this.mTable.getColumnPrefix() + this.getColumnName();
        }
        return this.mAliasedColumnName;
    }

    public Table getTable() {
        return this.mTable;
    }

    public int hashCode() {
        return this.mTable.hashCode() ^ this.getAttributeName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ColumnNode) {
            ColumnNode node = (ColumnNode)obj;
            return this.getAttributeName().equals(node.getAttributeName()) && this.mTable.equals(node.mTable);
        }
        return false;
    }

    public String getColumnName() {
        return this.getAttributeMap().getColumnName();
    }

    public String getAttributeName() {
        return this.mAttributeName;
    }

    public AttributeMap getAttributeMap() {
        if (this.mAttributeMap == null || !this.mTable.isValidPM()) {
            this.mAttributeMap = this.mTable.getClassMap().getAttributeMap(this.getAttributeName());
        }
        return this.mAttributeMap;
    }

    protected ColumnNode() {
    }
}

