/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.query.builder;

import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.SqlNode;
import com.raplix.rolloutexpress.persist.query.builder.ValueWrapper;
import com.raplix.rolloutexpress.persist.sql.Database;
import com.raplix.rolloutexpress.persist.sql.SQLStatement;

class Between
extends ConditionalExpression {
    private SqlNode inOperand;
    private SqlNode firstValue;
    private SqlNode secondValue;

    Between(ColumnNode inColumn, ValueWrapper inFirstValue, ValueWrapper inSecondValue) {
        this.inOperand = inColumn;
        this.firstValue = inFirstValue;
        this.secondValue = inSecondValue;
    }

    protected void writeExp(SQLStatement stmt) {
        Database db = PersistenceManager.getInstance().getDefaultDatabase();
        this.inOperand.writeSQL(stmt);
        stmt.addSQLClause(db.getClauseStringBetween()).addSQLClause(" ");
        this.firstValue.writeSQL(stmt);
        stmt.addSQLClause(db.getClauseStringAnd()).addSQLClause(" ");
        this.secondValue.writeSQL(stmt);
    }

    private Between() {
    }
}

