/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.query;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.persist.Messages;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.InvalidVersionRangeException;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.IntColumn;
import com.raplix.rolloutexpress.persist.query.builder.QueryBuilder;
import com.raplix.util.ObjectUtil;

public final class VersionRange
implements Messages {
    private VersionNumber mStart;
    private boolean mStartExact;
    private VersionNumber mEnd;
    private boolean mEndExact;
    private static final char SEPARATOR_CHAR = '&';
    private static final String EQUALS_STR = "=";
    private static final String LESS_THAN_STR = "<";
    private static final String GREATER_THAN_STR = ">";

    public static VersionRange create(String versionStr) throws PersistenceManagerException {
        VersionNumber start = null;
        VersionNumber end = null;
        boolean startExact = false;
        boolean endExact = false;
        String startStr = null;
        String endStr = null;
        int ndx = versionStr.indexOf(38);
        if (ndx != -1) {
            startStr = versionStr.substring(0, ndx);
            if (!startStr.startsWith(GREATER_THAN_STR)) {
                throw VersionRange.invalidFormat(versionStr);
            }
            startStr = startStr.substring(1);
            endStr = versionStr.substring(ndx + 1);
            if (!endStr.startsWith(LESS_THAN_STR)) {
                throw VersionRange.invalidFormat(versionStr);
            }
            endStr = endStr.substring(1);
        } else if (versionStr.startsWith(LESS_THAN_STR)) {
            endStr = versionStr.substring(1);
        } else if (versionStr.startsWith(GREATER_THAN_STR)) {
            startStr = versionStr.substring(1);
        } else if (versionStr.startsWith(EQUALS_STR)) {
            startStr = versionStr;
            endStr = versionStr;
        } else {
            throw VersionRange.invalidFormat(versionStr);
        }
        if (startStr != null) {
            if (startStr.startsWith(EQUALS_STR)) {
                startStr = startStr.substring(1);
                startExact = true;
            }
            start = new VersionNumber(startStr);
        }
        if (endStr != null) {
            if (endStr.startsWith(EQUALS_STR)) {
                endStr = endStr.substring(1);
                endExact = true;
            }
            end = new VersionNumber(endStr);
        }
        return new VersionRange(start, startExact, end, endExact);
    }

    private static InvalidVersionRangeException invalidFormat(String vString) {
        return new InvalidVersionRangeException(new ROXMessage("pm.qe.VER_RANGE_INVALID_FORMAT", new Object[]{vString}));
    }

    public VersionRange(VersionNumber start, boolean startExact, VersionNumber end, boolean endExact) throws InvalidVersionRangeException {
        if (start == null && end == null) {
            throw new NullPointerException();
        }
        if (start != null && end != null) {
            if (startExact && endExact) {
                if (!start.isLessThan(end) && !start.equals(end)) {
                    throw new InvalidVersionRangeException(new ROXMessage("pm.qe.VER_RANGE_START_GT_END", new String[]{start.toString(), end.toString()}));
                }
            } else if (!start.isLessThan(end)) {
                throw new InvalidVersionRangeException(new ROXMessage("pm.qe.VER_RANGE_START_GTE_END", new String[]{start.toString(), end.toString()}));
            }
        }
        this.mStart = start;
        this.mStartExact = startExact;
        this.mEnd = end;
        this.mEndExact = endExact;
    }

    public VersionNumber getRangeStart() {
        return this.mStart;
    }

    public boolean isRangeStartExact() {
        return this.mStartExact;
    }

    public VersionNumber getRangeEnd() {
        return this.mEnd;
    }

    public boolean isRangeEndExact() {
        return this.mEndExact;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof VersionRange)) {
            return false;
        }
        VersionRange otherRange = (VersionRange)other;
        return otherRange.isRangeStartExact() == this.isRangeStartExact() && ObjectUtil.equals(otherRange.getRangeStart(), this.getRangeStart()) && otherRange.isRangeEndExact() == this.isRangeEndExact() && ObjectUtil.equals(otherRange.getRangeEnd(), this.getRangeEnd());
    }

    public int hashCode() {
        int result = 0;
        if (this.getRangeStart() != null) {
            result += this.getRangeStart().hashCode();
        }
        if (this.isRangeStartExact()) {
            ++result;
        }
        if (this.getRangeEnd() != null) {
            result += this.getRangeEnd().hashCode();
        }
        if (this.isRangeEndExact()) {
            ++result;
        }
        return result;
    }

    public String toString() {
        VersionNumber start = this.getRangeStart();
        VersionNumber end = this.getRangeEnd();
        String result = null;
        if (start != null) {
            if (end != null && start.equals(end)) {
                return EQUALS_STR + start.getAsString();
            }
            result = this.isRangeStartExact() ? ">=" + start.getAsString() : GREATER_THAN_STR + start.getAsString();
        }
        if (end != null) {
            result = result != null ? result + '&' : "";
            result = this.isRangeEndExact() ? result + "<=" + end.getAsString() : result + LESS_THAN_STR + end.getAsString();
        }
        return result;
    }

    public boolean matches(VersionNumber version) {
        if (this.getRangeStart() == null) {
            return this.matchesEnd(version);
        }
        if (this.getRangeEnd() == null) {
            return this.matchesStart(version);
        }
        return this.matchesStart(version) && this.matchesEnd(version);
    }

    private boolean matchesEnd(VersionNumber version) {
        VersionNumber end = this.getRangeEnd();
        if (version.isLessThan(end)) {
            return true;
        }
        return this.isRangeEndExact() && version.equals(end);
    }

    private boolean matchesStart(VersionNumber version) {
        VersionNumber start = this.getRangeStart();
        if (version.isGreaterThan(start)) {
            return true;
        }
        return this.isRangeStartExact() && version.equals(start);
    }

    public ConditionalExpression getConditional(IntColumn versionColumn) {
        if (this.getRangeStart() == null) {
            return this.getEndConditional(versionColumn);
        }
        if (this.getRangeEnd() == null) {
            return this.getStartConditional(versionColumn);
        }
        if (this.getRangeStart().equals(this.getRangeEnd()) && this.isRangeStartExact() && this.isRangeEndExact()) {
            int version = this.getRangeStart().getSingleVersionNumber();
            return QueryBuilder.equals(versionColumn, version);
        }
        return QueryBuilder.and(this.getStartConditional(versionColumn), this.getEndConditional(versionColumn));
    }

    private ConditionalExpression getStartConditional(IntColumn versionColumn) {
        int start = this.getRangeStart().getSingleVersionNumber();
        if (this.isRangeStartExact()) {
            return QueryBuilder.greaterEquals(versionColumn, start);
        }
        return QueryBuilder.greaterThan(versionColumn, start);
    }

    private ConditionalExpression getEndConditional(IntColumn versionColumn) {
        int end = this.getRangeEnd().getSingleVersionNumber();
        if (this.isRangeEndExact()) {
            return QueryBuilder.lessEquals(versionColumn, end);
        }
        return QueryBuilder.lessThan(versionColumn, end);
    }
}

