/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.query;

import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.Query;
import com.raplix.rolloutexpress.persist.query.RawSQLQuery;
import com.raplix.rolloutexpress.persist.sql.Database;
import com.raplix.rolloutexpress.persist.sql.SQLStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SystemDataQuery
extends Query {
    private boolean mDataPreviouslyLoaded;

    public SystemDataQuery(Database db) {
        super(db, false);
    }

    protected void prepareToRunQuery() {
    }

    protected SQLStatement generateSQLStatement() {
        SQLStatement result = new SQLStatement();
        result.addSQLClause(this.getDatabase().getClauseStringSelect());
        result.addSQLClause(" C_DATA_LOAD_TIME ");
        result.addSQLClause(this.getDatabase().getClauseStringFrom());
        result.addSQLClause(" ROX_SYSTEM_DATA ");
        return result;
    }

    protected void processResultSet(ResultSet rs) throws SQLException {
        if (rs.next()) {
            this.mDataPreviouslyLoaded = true;
        }
    }

    protected void numRowsUpdated(int numRows) {
    }

    protected void finalizeQuery() {
    }

    public boolean hasDataBeenLoaded() throws PersistenceManagerException {
        this.mDataPreviouslyLoaded = false;
        this.runQuery();
        return this.mDataPreviouslyLoaded;
    }

    public void markDataLoadedTime() throws PersistenceManagerException {
        String setDataLoaded = "INSERT INTO ROX_SYSTEM_DATA(C_DATA_LOAD_TIME) VALUES(now())";
        new RawSQLQuery(this.getDatabase(), setDataLoaded).runQuery();
    }
}

