/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.query;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.PersistentServicesInit;
import com.raplix.rolloutexpress.persist.cache.CacheKey;
import com.raplix.rolloutexpress.persist.cache.SingleObjectByIDCache;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.BeanProcessor;
import com.raplix.rolloutexpress.persist.query.QueryImplBase;
import com.raplix.rolloutexpress.persist.query.SingleObjectErrorMapper;
import com.raplix.rolloutexpress.persist.query.SingleObjectQuery;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;

public abstract class SingleObjectQueryImpl
extends QueryImplBase
implements SingleObjectQuery {
    private Table mTable;
    private ConditionalExpression mWhereCondition;
    private String mCacheName = null;
    private CacheKey mCacheKey = null;
    private SingleObjectErrorMapper mErrorMapper = null;

    protected SingleObjectQueryImpl(Table table, ConditionalExpression whereCondition) {
        this(table, whereCondition, SingleObjectErrorMapper.DEFAULT);
    }

    protected SingleObjectQueryImpl(Table table, ConditionalExpression whereCondition, SingleObjectErrorMapper errorMapper) {
        this.mTable = table;
        this.mWhereCondition = whereCondition;
        this.mErrorMapper = errorMapper;
    }

    protected SingleObjectQueryImpl(Table table, ConditionalExpression whereCondition, String cacheName, CacheKey key, SingleObjectErrorMapper errorMapper) {
        this(table, whereCondition, errorMapper);
        this.mCacheName = cacheName;
        this.mCacheKey = key;
    }

    protected SingleObjectQueryImpl(Table t, ObjectID inObjectID) {
        this(t, Table.equals(t.ID, inObjectID), "byID", SingleObjectByIDCache.createKey(inObjectID), SingleObjectQueryImpl.getByIDErrorMapper(inObjectID));
    }

    protected Table getTable() {
        return this.mTable;
    }

    protected ConditionalExpression getWhereCondition() {
        return this.mWhereCondition;
    }

    protected CacheKey getCacheKey() {
        return this.mCacheKey;
    }

    protected String getCacheName() {
        return this.mCacheName;
    }

    public boolean selectExists() throws RPCException, PersistenceManagerException {
        Select query = this.getSelectStatement(this.getTable());
        return PersistentServicesInit.executeSingleExists(query, this.getTable(), this.getCacheName(), this.getCacheKey());
    }

    protected PersistentBean selectBean() throws RPCException, PersistenceManagerException {
        return (PersistentBean)this.select(new BeanProcessor(this.getTable(), true));
    }

    protected Object select(BeanProcessor processor) throws RPCException, PersistenceManagerException {
        Select query = this.getSelectStatement(this.getTable());
        processor.setErrorMapper(this.mErrorMapper);
        return PersistentServicesInit.executeSingleQuery(query, processor, this.getCacheName(), this.getCacheKey()).get(0);
    }

    protected Select getSelectStatement(Table t) {
        ConditionalExpression cond = this.getWhereCondition();
        return t.select(cond == null ? null : Table.where(cond));
    }

    private static SingleObjectErrorMapper getByIDErrorMapper(final ObjectID ID2) {
        return new SingleObjectErrorMapper(){

            public String getNoResultsFoundCode() {
                return "pm.NO_RESULTS_FOR_ID";
            }

            public String getTooManyResultsFoundCode() {
                return "pm.TOO_MANY_RESULTS_FOR_ID";
            }

            protected Object[] getArgs(ROXMessage objectName) {
                return new Object[]{objectName, ID2};
            }
        };
    }

    protected static SingleObjectErrorMapper getByNameErrorMapper(final String name) {
        return new SingleObjectErrorMapper(){

            public String getNoResultsFoundCode() {
                return "pm.NO_RESULTS_FOR_NAME";
            }

            public String getTooManyResultsFoundCode() {
                return "pm.TOO_MANY_RESULTS_FOR_NAME";
            }

            protected Object[] getArgs(ROXMessage objectName) {
                return new Object[]{objectName, name};
            }
        };
    }

    public static SingleObjectErrorMapper getByNameErrorMapper(final String name, final String version) {
        if (version == null) {
            return SingleObjectQueryImpl.getByNameErrorMapper(name);
        }
        return new SingleObjectErrorMapper(){

            public String getNoResultsFoundCode() {
                return "pm.NO_RESULTS_FOR_NAME_AND_VERSION";
            }

            public String getTooManyResultsFoundCode() {
                return "pm.TOO_MANY_RESULTS_FOR_NAME_AND_VERSION";
            }

            protected Object[] getArgs(ROXMessage objectName) {
                return new Object[]{objectName, name, version};
            }
        };
    }

    public static SingleObjectErrorMapper getByNameErrorMapper(FolderID inPathID, String name, String version) {
        name = inPathID.getFullPathString() + name;
        return SingleObjectQueryImpl.getByNameErrorMapper(name, version);
    }
}

