/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.query;

import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.PersistentBeanManagerImpl;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.map.ClassMap;
import com.raplix.rolloutexpress.persist.map.exception.ClassMapException;
import com.raplix.rolloutexpress.persist.query.Query;
import com.raplix.rolloutexpress.persist.query.exception.QueryException;
import com.raplix.rolloutexpress.persist.sql.SQLStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;

public abstract class SaveObjectQueryBase
extends Query {
    private ClassMap mClassMap;

    public SaveObjectQueryBase(ClassMap inClassMap) throws PersistenceManagerException {
        super(inClassMap.getDatabase(), true);
        this.mClassMap = inClassMap;
    }

    protected void prepareToRunQueryForObject(PersistentBean inBean) throws ClassMapException, SQLException, QueryException, PersistenceManagerException {
        if (this.mClassMap.getAssociationMaps().size() < 1) {
            return;
        }
        boolean isUpdate = this.mClassMap.getBeanManager().isPersistent(inBean);
        if (isUpdate) {
            PersistentBean oldObject = this.retrieve(this.mClassMap, this.mClassMap.getBeanManager().getObjectID(inBean), false);
            final HashSet savedAssociationIDs = new HashSet();
            this.forEachAssociation(inBean, new Query.Visitor(){

                public void visit(PersistentBean object) throws ClassMapException, SQLException, QueryException, PersistenceManagerException {
                    SaveObjectQueryBase.this.mClassMap.getBeanManager().save(object);
                    savedAssociationIDs.add(SaveObjectQueryBase.this.mClassMap.getBeanManager().getObjectID(object));
                }
            });
            this.forEachAssociation(oldObject, new Query.Visitor(){

                public void visit(PersistentBean object) throws ClassMapException, SQLException, QueryException, PersistenceManagerException {
                    if (!savedAssociationIDs.contains(SaveObjectQueryBase.this.mClassMap.getBeanManager().getObjectID(object))) {
                        SaveObjectQueryBase.this.mClassMap.getBeanManager().delete(object);
                    }
                }
            });
        } else {
            this.forEachAssociation(inBean, new Query.Visitor(){

                public void visit(PersistentBean object) throws ClassMapException, SQLException, QueryException, PersistenceManagerException {
                    SaveObjectQueryBase.this.mClassMap.getBeanManager().save(object);
                }
            });
        }
    }

    protected void addSQLStatementForObject(SQLStatement stmt, PersistentBean inBean) throws PersistenceManagerException {
        if (this.mClassMap.getBeanManager().isPersistent(inBean)) {
            stmt.addSQLStatement(this.mClassMap.getUpdateSQLFor(inBean));
        } else {
            ObjectID newID = this.mClassMap.getIDFactory().generateObjectID();
            this.mClassMap.getBeanManager().setObjectID(inBean, newID);
            stmt.addSQLStatement(this.mClassMap.getInsertSQLFor(inBean));
        }
    }

    protected void processResultSet(ResultSet inResultSet) throws ClassMapException, SQLException, QueryException, PersistenceManagerException {
    }

    protected void objectPostUpdate(PersistentBean inBean) throws QueryException {
        if (this.mClassMap.getBeanManager().isPersistent(inBean)) {
            this.mClassMap.getBeanManager().incrementUpdateCount(inBean);
        } else {
            this.mClassMap.getBeanManager().setPersistent(inBean, true);
        }
        this.mClassMap.removeCacheObject(this.mClassMap.getBeanManager().getObjectID(inBean));
    }

    protected ClassMap getClassMap() {
        return this.mClassMap;
    }

    protected PersistentBeanManagerImpl getBeanManager() {
        return this.mClassMap.getBeanManager();
    }
}

