/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.query;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.map.ClassMap;
import com.raplix.rolloutexpress.persist.map.exception.ClassMapException;
import com.raplix.rolloutexpress.persist.query.SaveObjectQueryBase;
import com.raplix.rolloutexpress.persist.query.exception.ObjectNotSavedQueryException;
import com.raplix.rolloutexpress.persist.query.exception.QueryException;
import com.raplix.rolloutexpress.persist.sql.SQLStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SaveObjectQuery
extends SaveObjectQueryBase {
    private PersistentBean mObject;

    public SaveObjectQuery(ClassMap inClassMap, PersistentBean inObject) throws PersistenceManagerException {
        super(inClassMap);
        this.mObject = inObject;
    }

    protected void prepareToRunQuery() throws ClassMapException, SQLException, QueryException, PersistenceManagerException {
        this.prepareToRunQueryForObject(this.mObject);
    }

    protected SQLStatement generateSQLStatement() throws ClassMapException, PersistenceManagerException {
        SQLStatement stmt = new SQLStatement();
        this.addSQLStatementForObject(stmt, this.mObject);
        return stmt;
    }

    protected void processResultSet(ResultSet inResultSet) throws ClassMapException, SQLException, QueryException, PersistenceManagerException {
    }

    protected void numRowsUpdated(int numRowsAffected) throws QueryException {
        if (numRowsAffected != 1) {
            ROXMessage objectName = PersistenceManager.getObjectName(this.mObject.getClass());
            throw new ObjectNotSavedQueryException(new ROXMessage("pm.OBJECT_COULD_NOT_BE_SAVED", (Object[])new String[]{objectName.toString()}, 2000));
        }
        this.objectPostUpdate(this.mObject);
    }

    protected void finalizeQuery() throws ClassMapException, SQLException, QueryException, PersistenceManagerException {
    }
}

