/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.query;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.persist.Messages;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.map.ClassMap;
import com.raplix.rolloutexpress.persist.map.exception.ClassMapException;
import com.raplix.rolloutexpress.persist.query.SaveObjectQueryBase;
import com.raplix.rolloutexpress.persist.query.exception.QueryException;
import com.raplix.rolloutexpress.persist.sql.SQLStatement;
import java.sql.SQLException;

public class SaveMultiObjectQuery
extends SaveObjectQueryBase
implements Messages {
    private PersistentBean[] mObjects;

    public SaveMultiObjectQuery(ClassMap inClassMap, PersistentBean[] inObjects) throws PersistenceManagerException {
        super(inClassMap);
        this.mObjects = inObjects;
        for (int i = 0; i < inObjects.length; ++i) {
            if (!this.getBeanManager().isPersistent(inObjects[i])) continue;
            throw new QueryException(new ROXMessage("pm.qe.BATCH_SAVE_UPDATE"));
        }
    }

    protected void prepareToRunQuery() throws ClassMapException, SQLException, QueryException, PersistenceManagerException {
        if (this.getClassMap().getAssociationMaps().size() < 1) {
            return;
        }
        for (int i = 0; i < this.mObjects.length; ++i) {
            this.prepareToRunQueryForObject(this.mObjects[i]);
        }
    }

    protected SQLStatement generateSQLStatement() throws ClassMapException, PersistenceManagerException {
        SQLStatement stmt = new SQLStatement();
        for (int i = 0; i < this.mObjects.length; ++i) {
            if (i > 0) {
                stmt.addSQLClause(" ; ");
            }
            this.addSQLStatementForObject(stmt, this.mObjects[i]);
        }
        return stmt;
    }

    protected void numRowsUpdated(int numRowsAffected) throws QueryException {
        for (int i = 0; i < this.mObjects.length; ++i) {
            this.objectPostUpdate(this.mObjects[i]);
        }
    }

    protected void finalizeQuery() throws SQLException, PersistenceManagerException {
    }
}

