/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.query;

import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.map.exception.ClassMapException;
import com.raplix.rolloutexpress.persist.query.Query;
import com.raplix.rolloutexpress.persist.query.exception.QueryException;
import com.raplix.rolloutexpress.persist.sql.Database;
import com.raplix.rolloutexpress.persist.sql.SQLStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class RetriveTableInformationQuery
extends Query {
    String mTableName;
    Vector mTableColumnNames;

    public RetriveTableInformationQuery(Database inDatabase, String inTableName) {
        super(inDatabase, false);
        this.mTableName = inTableName;
        this.mTableColumnNames = new Vector();
    }

    public boolean doesTableExist() {
        return this.mTableColumnNames.size() > 0;
    }

    public boolean doesColumnExist(String inColumnName) {
        return this.mTableColumnNames.contains(inColumnName.toUpperCase());
    }

    protected void prepareToRunQuery() throws ClassMapException, SQLException, QueryException, PersistenceManagerException {
    }

    protected SQLStatement generateSQLStatement() throws ClassMapException, PersistenceManagerException {
        SQLStatement stmt = new SQLStatement();
        stmt.addSQLClause(this.getDatabase().getClauseTableInformation(this.mTableName));
        return stmt;
    }

    protected void processResultSet(ResultSet inResultSet) throws ClassMapException, SQLException, QueryException, PersistenceManagerException {
        while (inResultSet.next()) {
            String columnName = inResultSet.getString(this.getDatabase().getColumnNameTableInformationColumnName());
            this.mTableColumnNames.add(columnName.toUpperCase());
        }
    }

    protected void numRowsUpdated(int numRowsAffected) throws QueryException {
    }

    protected void finalizeQuery() throws ClassMapException, SQLException, QueryException, PersistenceManagerException {
    }
}

