/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.query;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.VersionedPersistentObject;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.map.ClassMap;
import com.raplix.rolloutexpress.persist.map.exception.ClassMapException;
import com.raplix.rolloutexpress.persist.query.Query;
import com.raplix.rolloutexpress.persist.query.exception.ObjectNotRetrievedQueryException;
import com.raplix.rolloutexpress.persist.query.exception.QueryException;
import com.raplix.rolloutexpress.persist.sql.Database;
import com.raplix.rolloutexpress.persist.sql.SQLStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class RetrieveVersionedObjectQuery
extends Query {
    private ClassMap mClassMap;
    private ObjectID mRootID;
    private VersionNumber mVersionNumber;
    private VersionedPersistentObject mRetrievedObject = null;
    private int mFlushCount;

    public RetrieveVersionedObjectQuery(Database inDatabase, ClassMap inClassMap, ObjectID inRootID, VersionNumber inNumber) {
        super(inDatabase, false);
        inClassMap.checkReadPermission();
        this.mClassMap = inClassMap;
        this.mRootID = inRootID;
        this.mVersionNumber = inNumber;
    }

    protected void finalizeQuery() throws PersistenceManagerException, QueryException, SQLException, ClassMapException {
        if (this.mRetrievedObject != null) {
            this.loadAssociations(this.mClassMap, this.mRetrievedObject);
            this.mClassMap.updateCache(this.mRetrievedObject, this.mFlushCount);
        }
    }

    protected SQLStatement generateSQLStatement() throws PersistenceManagerException, ClassMapException {
        SQLStatement theStatement = this.mClassMap.getTableAndColumnSelectionClause();
        StringBuffer whereClause = new StringBuffer(this.getDatabase().getClauseStringWhere());
        whereClause.append(" ").append("ROOT_ID");
        whereClause.append("=").append(this.mRootID.generateSQLInsertValues());
        whereClause.append(" ").append(this.getDatabase().getClauseStringAnd()).append(" ");
        whereClause.append("VERSION").append("=");
        whereClause.append("'").append(this.mVersionNumber.getSingleVersionNumber()).append("'");
        theStatement.addSQLClause(whereClause.toString());
        return theStatement;
    }

    protected void prepareToRunQuery() throws PersistenceManagerException, QueryException, SQLException, ClassMapException {
        this.mFlushCount = this.mClassMap.getCacheFlushCount();
    }

    protected void processResultSet(ResultSet inResultSet) throws PersistenceManagerException, QueryException, SQLException, ClassMapException {
        if (!inResultSet.next()) {
            throw new ObjectNotRetrievedQueryException(new ROXMessage("pm.qe.OBJECT_NOT_RETRIEVED_VERSION", this.mRootID.toString(), this.mVersionNumber.toString()));
        }
        this.mRetrievedObject = (VersionedPersistentObject)this.mClassMap.newInstance();
        this.mClassMap.retrieveObject(this.mRetrievedObject, inResultSet);
    }

    protected void numRowsUpdated(int numRowsAffected) throws QueryException {
    }

    public VersionedPersistentObject getRetrievedObject() throws ObjectNotRetrievedQueryException {
        if (this.mRetrievedObject == null) {
            throw new ObjectNotRetrievedQueryException(new ROXMessage("pm.qe.OBJECT_NOT_RETRIEVED_VERSION", this.mRootID.toString(), this.mVersionNumber.toString()));
        }
        return this.mRetrievedObject;
    }
}

