/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.query;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.map.ClassMap;
import com.raplix.rolloutexpress.persist.map.exception.ClassMapException;
import com.raplix.rolloutexpress.persist.query.Query;
import com.raplix.rolloutexpress.persist.query.QueryResults;
import com.raplix.rolloutexpress.persist.query.exception.QueryException;
import com.raplix.rolloutexpress.persist.sql.Database;
import com.raplix.rolloutexpress.persist.sql.SQLStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class RetrieveObjectsWhereClauseQuery
extends Query {
    QueryResults mQueryResults;
    ClassMap mClassMap;
    String mWhereClause;
    boolean mLoadAssociations;

    public RetrieveObjectsWhereClauseQuery(Database inDatabase, ClassMap inClassMap, String inWhereClause) throws ClassMapException {
        this(inDatabase, inClassMap, inWhereClause, true);
    }

    public RetrieveObjectsWhereClauseQuery(Database inDatabase, ClassMap inClassMap, String inWhereClause, boolean inLoadAssociations) throws ClassMapException {
        super(inDatabase, false);
        inClassMap.checkReadPermission();
        this.mClassMap = inClassMap;
        this.mQueryResults = new QueryResults();
        this.mWhereClause = inWhereClause;
        this.mLoadAssociations = inLoadAssociations;
    }

    public QueryResults getQueryResults() {
        return this.mQueryResults;
    }

    protected void prepareToRunQuery() throws ClassMapException, SQLException, QueryException, PersistenceManagerException {
    }

    protected SQLStatement generateSQLStatement() throws ClassMapException, PersistenceManagerException {
        SQLStatement theStatement = this.mClassMap.getTableAndColumnSelectionClause();
        if (this.mWhereClause != null && !this.mWhereClause.equals("")) {
            theStatement.addSQLClause(this.mWhereClause);
        }
        return theStatement;
    }

    protected void processResultSet(ResultSet inResultSet) throws ClassMapException, SQLException, QueryException, PersistenceManagerException {
        PersistentBean currObject = null;
        while (inResultSet.next()) {
            try {
                currObject = (PersistentBean)this.mClassMap.getMappedClass().newInstance();
                this.mClassMap.retrieveObject(currObject, inResultSet);
                this.mQueryResults.add(currObject);
            }
            catch (IllegalAccessException e) {
                throw new ClassMapException(new ROXMessage("pm.query.CANT_INSTANCIATE_OBJECT"), (Throwable)e, 1);
            }
            catch (InstantiationException e) {
                throw new ClassMapException(new ROXMessage("pm.query.CANT_INSTANCIATE_OBJECT"), (Throwable)e, 1);
            }
        }
    }

    protected void numRowsUpdated(int numRowsAffected) throws QueryException {
    }

    protected void finalizeQuery() throws ClassMapException, SQLException, QueryException, PersistenceManagerException {
        if (this.mLoadAssociations) {
            while (this.mQueryResults.hasNext()) {
                this.loadAssociations(this.mClassMap, this.mQueryResults.next());
            }
            this.mQueryResults.reset();
        }
    }
}

