/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.query;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.persist.Messages;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.map.ClassMap;
import com.raplix.rolloutexpress.persist.map.exception.ClassMapException;
import com.raplix.rolloutexpress.persist.query.Query;
import com.raplix.rolloutexpress.persist.query.exception.ObjectHasNoIDQueryException;
import com.raplix.rolloutexpress.persist.query.exception.ObjectNotRetrievedQueryException;
import com.raplix.rolloutexpress.persist.query.exception.QueryException;
import com.raplix.rolloutexpress.persist.sql.SQLStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class RetrieveObjectQuery
extends Query
implements Messages {
    PersistentBean mObject;
    ClassMap mClassMap;
    int mFlushCount;
    boolean mObjectRetrieved = false;
    boolean mLoadAssociations;

    public RetrieveObjectQuery(ClassMap inClassMap, PersistentBean inObject) throws ClassMapException {
        this(inClassMap, inObject, true);
    }

    public RetrieveObjectQuery(ClassMap inClassMap, PersistentBean inObject, boolean inLoadAssociations) throws ClassMapException {
        super(inClassMap.getDatabase(), false);
        this.mObject = inObject;
        this.mClassMap = inClassMap;
        this.mLoadAssociations = inLoadAssociations;
    }

    protected void prepareToRunQuery() throws ClassMapException, SQLException, QueryException, PersistenceManagerException {
        if (this.mClassMap.getBeanManager().getObjectID(this.mObject) == null) {
            throw new ObjectHasNoIDQueryException(new ROXMessage("pm.qe.OBJECT_HAS_NO_ID", new String[]{this.mObject.toString()}));
        }
        this.mFlushCount = this.mClassMap.getCacheFlushCount();
    }

    protected SQLStatement generateSQLStatement() throws ClassMapException, PersistenceManagerException {
        return this.mClassMap.getSelectSQLFor(this.mObject);
    }

    protected void processResultSet(ResultSet inResultSet) throws ClassMapException, SQLException, QueryException, PersistenceManagerException {
        if (!inResultSet.next()) {
            throw new ObjectNotRetrievedQueryException(new ROXMessage("pm.qe.OBJECT_NOT_RETRIEVED", this.mClassMap.getBeanManager().getObjectID(this.mObject).toString()));
        }
        this.mClassMap.retrieveObject(this.mObject, inResultSet);
        this.mObjectRetrieved = true;
    }

    protected void numRowsUpdated(int numRowsAffected) throws QueryException {
    }

    protected void finalizeQuery() throws ClassMapException, SQLException, QueryException, PersistenceManagerException {
        if (this.mLoadAssociations) {
            this.loadAssociations(this.mClassMap, this.mObject);
        }
        if (this.mObjectRetrieved) {
            this.mClassMap.updateCache(this.mObject, this.mFlushCount);
        }
    }
}

