/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.query;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.VersionedPersistentBean;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.map.ClassMap;
import com.raplix.rolloutexpress.persist.map.exception.ClassMapException;
import com.raplix.rolloutexpress.persist.query.Query;
import com.raplix.rolloutexpress.persist.query.exception.ObjectNotRetrievedQueryException;
import com.raplix.rolloutexpress.persist.query.exception.QueryException;
import com.raplix.rolloutexpress.persist.sql.Database;
import com.raplix.rolloutexpress.persist.sql.SQLStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class RetrieveLatestVersionQuery
extends Query {
    private ClassMap mClassMap;
    private ObjectID mRootID;
    private VersionedPersistentBean mRetrievedObject = null;
    private int mFlushCount;

    public RetrieveLatestVersionQuery(Database inDatabase, ClassMap inClassMap, ObjectID inRootID) {
        super(inDatabase, false);
        inClassMap.checkReadPermission();
        this.mClassMap = inClassMap;
        this.mRootID = inRootID;
    }

    protected void finalizeQuery() throws PersistenceManagerException, QueryException, SQLException, ClassMapException {
        if (this.mRetrievedObject != null) {
            this.loadAssociations(this.mClassMap, this.mRetrievedObject);
            this.mClassMap.updateCache(this.mRetrievedObject, this.mFlushCount);
        }
    }

    protected SQLStatement generateSQLStatement() throws PersistenceManagerException, ClassMapException {
        SQLStatement theStatement = this.mClassMap.getTableAndColumnSelectionClause();
        StringBuffer whereClause = new StringBuffer(this.getDatabase().getClauseStringWhere());
        whereClause.append(" ").append("ROOT_ID");
        whereClause.append("=").append(this.mRootID.generateSQLInsertValues());
        whereClause.append(" ").append(this.getDatabase().getClauseStringAnd()).append(" ");
        whereClause.append("VERSION").append("=");
        whereClause.append("(").append(this.getDatabase().getClauseStringSelect()).append(" ");
        whereClause.append("MAX(").append("VERSION");
        whereClause.append(")").append(" from ").append(this.mClassMap.getTableMap().getTableName());
        whereClause.append(" ").append(this.getDatabase().getClauseStringWhere());
        whereClause.append(" ").append(this.mClassMap.getTableMap().getTableName());
        whereClause.append(".").append("ROOT_ID").append("=");
        whereClause.append(this.mRootID.generateSQLInsertValues()).append(")");
        theStatement.addSQLClause(whereClause.toString());
        return theStatement;
    }

    protected void prepareToRunQuery() throws PersistenceManagerException, QueryException, SQLException, ClassMapException {
        this.mFlushCount = this.mClassMap.getCacheFlushCount();
    }

    protected void processResultSet(ResultSet inResultSet) throws PersistenceManagerException, QueryException, SQLException, ClassMapException {
        if (!inResultSet.next()) {
            throw new ObjectNotRetrievedQueryException(new ROXMessage("pm.qe.OBJECT_NOT_RETRIEVED_LATEST", this.mRootID.toString()));
        }
        this.mRetrievedObject = (VersionedPersistentBean)this.mClassMap.newInstance();
        this.mClassMap.retrieveObject(this.mRetrievedObject, inResultSet);
    }

    protected void numRowsUpdated(int numRowsAffected) throws QueryException {
    }

    public VersionedPersistentBean getRetrievedObject() throws ObjectNotRetrievedQueryException {
        if (this.mRetrievedObject == null) {
            throw new ObjectNotRetrievedQueryException(new ROXMessage("pm.qe.OBJECT_NOT_RETRIEVED_LATEST", this.mRootID.toString()));
        }
        return this.mRetrievedObject;
    }
}

