/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.query;

import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.VersionedPersistentObject;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.map.ClassMap;
import com.raplix.rolloutexpress.persist.map.exception.ClassMapException;
import com.raplix.rolloutexpress.persist.query.Query;
import com.raplix.rolloutexpress.persist.query.exception.QueryException;
import com.raplix.rolloutexpress.persist.sql.Database;
import com.raplix.rolloutexpress.persist.sql.SQLStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Vector;

public class RetrieveAllVersionsQuery
extends Query {
    private ClassMap mClassMap;
    private ObjectID mRootID;
    private Vector mRetrievedObjects = new Vector();
    private int mFlushCount;

    public RetrieveAllVersionsQuery(Database inDatabase, ClassMap inClassMap, ObjectID inRootID) {
        super(inDatabase, false);
        inClassMap.checkReadPermission();
        this.mClassMap = inClassMap;
        this.mRootID = inRootID;
    }

    protected void finalizeQuery() throws PersistenceManagerException, QueryException, SQLException, ClassMapException {
        Enumeration e = this.mRetrievedObjects.elements();
        while (e.hasMoreElements()) {
            PersistentBean obj = (PersistentBean)e.nextElement();
            this.loadAssociations(this.mClassMap, obj);
            this.mClassMap.updateCache(obj, this.mFlushCount);
        }
    }

    protected SQLStatement generateSQLStatement() throws PersistenceManagerException, ClassMapException {
        SQLStatement theStatement = this.mClassMap.getTableAndColumnSelectionClause();
        StringBuffer whereClause = new StringBuffer(this.getDatabase().getClauseStringWhere());
        whereClause.append(" ").append("ROOT_ID");
        whereClause.append("=").append(this.mRootID.generateSQLInsertValues());
        theStatement.addSQLClause(whereClause.toString());
        return theStatement;
    }

    protected void prepareToRunQuery() throws PersistenceManagerException, QueryException, SQLException, ClassMapException {
        this.mFlushCount = this.mClassMap.getCacheFlushCount();
    }

    protected void processResultSet(ResultSet inResultSet) throws PersistenceManagerException, QueryException, SQLException, ClassMapException {
        VersionedPersistentObject obj = null;
        while (inResultSet.next()) {
            obj = (VersionedPersistentObject)this.mClassMap.newInstance();
            this.mClassMap.retrieveObject(obj, inResultSet);
            this.mRetrievedObjects.add(obj);
        }
    }

    public VersionedPersistentObject[] getRetrievedObjects() {
        VersionedPersistentObject[] vpo = this.mRetrievedObjects.toArray(new VersionedPersistentObject[this.mRetrievedObjects.size()]);
        Arrays.sort(vpo, new Comparator(){

            public int compare(Object o1, Object o2) {
                VersionedPersistentObject vpo1 = (VersionedPersistentObject)o1;
                VersionedPersistentObject vpo2 = (VersionedPersistentObject)o2;
                return -vpo1.getVersionNumber().compareTo(vpo2.getVersionNumber());
            }
        });
        return vpo;
    }

    protected void numRowsUpdated(int numRowsAffected) throws QueryException {
    }
}

