/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.query;

import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.persist.query.TooManyResultsFoundException;
import com.raplix.rolloutexpress.persist.query.builder.ResultSetProcessor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Vector;

public abstract class ResultProcessor
extends ResultSetProcessor
implements RPCSerializable {
    protected Vector mResults = new Vector();
    private boolean mSingleResult;

    public ResultProcessor(boolean isSingleResult) {
        this.mSingleResult = isSingleResult;
    }

    public ResultProcessor() {
        this(false);
    }

    public final void processResultSet(ResultSet inResultSet) throws PersistenceManagerException, SQLException {
        if (this.mSingleResult) {
            this.processSingleRowResultSet(inResultSet);
        } else {
            this.processMultiRowResultSet(inResultSet);
        }
    }

    private void processMultiRowResultSet(ResultSet inResultSet) throws PersistenceManagerException, SQLException {
        while (inResultSet.next()) {
            this.mResults.add(this.processRow(inResultSet));
        }
    }

    private void processSingleRowResultSet(ResultSet inResultSet) throws PersistenceManagerException, SQLException {
        if (!inResultSet.next()) {
            throw this.newNoResultsFoundException();
        }
        this.mResults.add(this.processRow(inResultSet));
        if (inResultSet.next()) {
            throw this.newTooManyResultsFoundException();
        }
    }

    protected NoResultsFoundException newNoResultsFoundException() {
        return new NoResultsFoundException();
    }

    protected TooManyResultsFoundException newTooManyResultsFoundException() {
        return new TooManyResultsFoundException();
    }

    public abstract Object processRow(ResultSet var1) throws PersistenceManagerException, SQLException;

    public Vector getResults() throws PersistenceManagerException {
        return this.mResults;
    }

    public final Iterator getResultIterator() {
        return this.mResults.iterator();
    }

    protected void mapResults() throws PersistenceManagerException {
        int size = this.mResults.size();
        for (int i = 0; i < size; ++i) {
            this.mResults.set(i, this.mapObject(this.mResults.get(i)));
        }
    }

    protected Object mapObject(Object obj) throws PersistenceManagerException {
        return obj;
    }
}

