/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.query;

import com.raplix.rolloutexpress.persist.query.MultiObjectQueryImpl;

public class ResultCount {
    public static final int UNDEFINED = -1;
    private int mTotalCount;
    private int mPageSize;
    private int mPageNum;

    public ResultCount(int totalCount, int pageSize, int pageNum) {
        this.mTotalCount = totalCount;
        this.setPageSize(pageSize);
        this.setPageNum(pageNum);
    }

    public ResultCount(int totalCount) {
        this(totalCount, -1, 1);
    }

    public int getTotalItemCount() {
        return this.mTotalCount;
    }

    public int getPageCount() {
        int pageSize = this.getPageSize();
        if (pageSize == -1) {
            return 1;
        }
        return (this.getTotalItemCount() + pageSize - 1) / pageSize;
    }

    public int getFirstPos() {
        int pageSize = this.getPageSize();
        if (pageSize == -1) {
            return 1;
        }
        int pageNum = this.getPageNum();
        if (pageNum > this.getPageCount()) {
            return -1;
        }
        return (pageNum - 1) * pageSize + 1;
    }

    public int getLastPos() {
        int pageCount;
        int pageSize = this.getPageSize();
        if (pageSize == -1) {
            return this.getTotalItemCount();
        }
        int pageNum = this.getPageNum();
        if (pageNum > (pageCount = this.getPageCount())) {
            return -1;
        }
        if (pageNum < pageCount) {
            return pageNum * pageSize;
        }
        return this.getTotalItemCount();
    }

    public int getPageNum() {
        return this.mPageNum;
    }

    public void setPageNum(int pageNum) {
        MultiObjectQueryImpl.validatePageNum(pageNum);
        this.mPageNum = pageNum;
    }

    public int getPageSize() {
        return this.mPageSize;
    }

    public void setPageSize(int pageSize) {
        MultiObjectQueryImpl.validatePageSize(pageSize);
        this.mPageSize = pageSize;
    }
}

