/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.query;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.PersistContext;
import com.raplix.rolloutexpress.persist.PersistentServicesInit;
import com.raplix.rolloutexpress.persist.RPCTransaction;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.BeanProcessor;
import com.raplix.rolloutexpress.persist.query.BooleanProcessor;
import com.raplix.rolloutexpress.persist.query.ResultProcessor;
import com.raplix.rolloutexpress.persist.query.builder.IntColumn;
import com.raplix.rolloutexpress.persist.query.builder.QueryBuilder;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.StringColumn;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class QueryImplBase {
    protected static final QueryBuilder QB = null;

    protected Vector selectResults(Select query, ResultProcessor processor) throws RPCException, PersistenceManagerException {
        return PersistentServicesInit.executeQuery(query, processor);
    }

    protected Object selectFirst(Select query, ResultProcessor processor) throws RPCException, PersistenceManagerException {
        return this.selectResults(query, processor).get(0);
    }

    protected Object[] selectArray(Select query, ResultProcessor processor, Class type) throws RPCException, PersistenceManagerException {
        Vector results = this.selectResults(query, processor);
        return this.toArray(results, type);
    }

    private Object[] toArray(Vector v, Class type) {
        return v.toArray((Object[])Array.newInstance(type, v.size()));
    }

    protected int selectIntResult(Select query) throws RPCException, PersistenceManagerException {
        return ((int[])this.selectFirst(query, new IntProcessor(true)))[0];
    }

    protected boolean selectBooleanResult(Select query) throws RPCException, PersistenceManagerException {
        return ((boolean[])this.selectFirst(query, new BooleanProcessor(true)))[0];
    }

    protected boolean selectExists(Select query) throws RPCException, PersistenceManagerException {
        return this.selectBooleanResult(QueryBuilder.selectExists(query));
    }

    protected String[] selectStringArrayResult(Select query) throws RPCException, PersistenceManagerException {
        return (String[])this.selectArray(query, new StringProcessor(), String.class);
    }

    protected Object[] selectByIDs(Table table, ObjectID[] inObjectIDs, BeanProcessor processor, Class type) throws RPCException, PersistenceManagerException {
        Vector results = PersistentServicesInit.fetchByIDs(table, inObjectIDs, processor);
        return this.toArray(results, type);
    }

    protected static PersistContext transactRPC(RPCTransaction inTransaction) throws RPCException, PersistenceManagerException {
        return PersistentServicesInit.transact(inTransaction);
    }

    protected static class StringProcessor
    extends ResultProcessor {
        public StringProcessor(boolean isSingleResult) {
            super(isSingleResult);
        }

        public StringProcessor() {
        }

        public Object processRow(ResultSet inResultSet) throws SQLException {
            return StringColumn.getValue(inResultSet, 1);
        }
    }

    protected static class IntProcessor
    extends ResultProcessor {
        public IntProcessor(boolean isSingleResult) {
            super(isSingleResult);
        }

        public IntProcessor() {
        }

        public Object processRow(ResultSet inResultSet) throws SQLException {
            return new int[]{IntColumn.getValue(inResultSet, 1)};
        }
    }
}

