/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.query;

import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.QueryBuilder;
import com.raplix.rolloutexpress.persist.query.builder.ScalarExp;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.persist.query.builder.TableClause;
import com.raplix.rolloutexpress.persist.query.builder.TableList;
import com.raplix.rolloutexpress.persist.query.builder.WhereClause;

public class QueryContext {
    private TableList mTableList;
    private ConditionalExpression mWhereCondition;
    private SelectList mSelectList;
    private Object mClientContext;

    QueryContext(SelectList inSelectList, TableList inTableList, ConditionalExpression inExp, Object inClientContext) {
        if (inSelectList == null || inTableList == null) {
            throw new NullPointerException();
        }
        this.mSelectList = inSelectList;
        this.mTableList = inTableList;
        this.mWhereCondition = inExp;
        this.mClientContext = inClientContext;
    }

    public void addTable(TableClause inTable) {
        if (inTable == null) {
            throw new NullPointerException();
        }
        this.mTableList = QueryBuilder.tList(this.mTableList, inTable);
    }

    public void addAndWhereCondition(ConditionalExpression inExp) {
        if (inExp == null) {
            throw new NullPointerException();
        }
        this.mWhereCondition = this.mWhereCondition == null ? inExp : QueryBuilder.and(this.mWhereCondition, inExp);
    }

    public void addOrWhereCondition(ConditionalExpression inExp) {
        if (inExp == null) {
            throw new NullPointerException();
        }
        this.mWhereCondition = this.mWhereCondition == null ? inExp : QueryBuilder.or(this.mWhereCondition, inExp);
    }

    public void addToSelectList(ScalarExp inExp) {
        if (inExp == null) {
            throw new NullPointerException();
        }
        this.mSelectList.add(inExp);
    }

    public void addAllColumnsToSelectList(Table inTable) {
        if (inTable == null) {
            throw new NullPointerException();
        }
        this.mSelectList.add(inTable.allColumns());
    }

    TableList getTableList() {
        return this.mTableList;
    }

    public Table getFirstTable() {
        return (Table)this.mTableList.elementAt(0);
    }

    ConditionalExpression getWhereCondition() {
        return this.mWhereCondition;
    }

    SelectList getSelectList() {
        return this.mSelectList;
    }

    public Table getTableOfType(Class tableClass) {
        return this.mTableList.getTableOfType(tableClass);
    }

    WhereClause getWhereClause() {
        return this.mWhereCondition == null ? null : QueryBuilder.where(this.mWhereCondition);
    }

    public Object getClientContext() {
        return this.mClientContext;
    }
}

