/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.query;

import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.Transaction;
import com.raplix.rolloutexpress.persist.TransactionContext;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.exception.TransactionNonExistentException;
import com.raplix.rolloutexpress.persist.map.ClassMap;
import com.raplix.rolloutexpress.persist.map.attribute.AssociationAttributeMap;
import com.raplix.rolloutexpress.persist.map.exception.ClassMapException;
import com.raplix.rolloutexpress.persist.query.RetrieveObjectQuery;
import com.raplix.rolloutexpress.persist.query.exception.NoTransactionContextQueryException;
import com.raplix.rolloutexpress.persist.query.exception.QueryException;
import com.raplix.rolloutexpress.persist.sql.DBConnection;
import com.raplix.rolloutexpress.persist.sql.Database;
import com.raplix.rolloutexpress.persist.sql.SQLStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;

public abstract class Query {
    boolean mIsUpdate;
    Database mDatabase;

    public Query(Database inDatabase, boolean isUpdate) {
        this.mIsUpdate = isUpdate;
        this.mDatabase = inDatabase;
    }

    public Database getDatabase() {
        return this.mDatabase;
    }

    public void runQuery() throws ClassMapException, QueryException, PersistenceManagerException {
        final Query theQuery = this;
        PersistenceManager.getInstance().getTransactionManager().transact(new Transaction(){

            public Object execute() throws ClassMapException, SQLException, PersistenceManagerException, QueryException {
                theQuery.doRunQuery();
                return theQuery;
            }
        }, this.mDatabase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRunQuery() throws ClassMapException, SQLException, QueryException, PersistenceManagerException {
        this.prepareToRunQuery();
        PersistenceManager thePM = PersistenceManager.getInstance();
        TransactionContext theTransContext = null;
        try {
            theTransContext = thePM.getTransactionManager().getTransactionContext();
        }
        catch (TransactionNonExistentException e) {
            throw new NoTransactionContextQueryException();
        }
        DBConnection conn = theTransContext.getConnection();
        try {
            this.runQueryImpl(conn);
        }
        finally {
            this.finalizeQuery();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runQueryImpl(DBConnection inConnection) throws ClassMapException, SQLException, QueryException, PersistenceManagerException {
        SQLStatement stmt;
        block7: {
            stmt = null;
            ResultSet rs = null;
            int numRowsAffected = 0;
            try {
                stmt = this.generateSQLStatement();
                if (this.mIsUpdate) {
                    numRowsAffected = inConnection.processUpdate(stmt);
                    this.numRowsUpdated(numRowsAffected);
                } else {
                    rs = inConnection.processQuery(stmt);
                    this.processResultSet(rs);
                }
                Object var6_5 = null;
                if (rs == null) break block7;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                throw throwable;
            }
            rs.close();
        }
        if (stmt != null) {
            stmt.close();
        }
    }

    protected void forEachAssociation(PersistentBean obj, Visitor visitor) throws ClassMapException, SQLException, QueryException, PersistenceManagerException {
        ClassMap classMap = PersistenceManager.getBeanManager().getClassMap(obj);
        HashMap theAssociationMaps = classMap.getAssociationMaps();
        Iterator theIT = theAssociationMaps.values().iterator();
        while (theIT.hasNext()) {
            AssociationAttributeMap currMap = (AssociationAttributeMap)theIT.next();
            PersistentBean[] theTargets = currMap.isArray() ? (PersistentBean[])currMap.getValue(obj) : new PersistentBean[]{(PersistentBean)currMap.getValue(obj)};
            for (int i = 0; theTargets != null && i < theTargets.length; ++i) {
                if (theTargets[i] == null) continue;
                visitor.visit(theTargets[i]);
            }
        }
    }

    protected void loadAssociations(ClassMap inClassMap, PersistentBean obj) throws ClassMapException, SQLException, QueryException, PersistenceManagerException {
        inClassMap.loadAssociations(obj);
        inClassMap.getBeanManager().setPersistent(obj, true);
    }

    protected PersistentBean retrieve(ClassMap classMap, ObjectID id, boolean deep) throws ClassMapException, SQLException, QueryException, PersistenceManagerException {
        PersistentBean result = classMap.newInstance();
        classMap.getBeanManager().setObjectID(result, id);
        RetrieveObjectQuery theQuery = new RetrieveObjectQuery(classMap, result, deep);
        theQuery.runQuery();
        return result;
    }

    protected abstract void prepareToRunQuery() throws ClassMapException, SQLException, QueryException, PersistenceManagerException;

    protected abstract SQLStatement generateSQLStatement() throws ClassMapException, PersistenceManagerException;

    protected abstract void processResultSet(ResultSet var1) throws ClassMapException, SQLException, QueryException, PersistenceManagerException;

    protected abstract void numRowsUpdated(int var1) throws QueryException;

    protected abstract void finalizeQuery() throws ClassMapException, SQLException, QueryException, PersistenceManagerException;

    protected static interface Visitor {
        public void visit(PersistentBean var1) throws ClassMapException, SQLException, QueryException, PersistenceManagerException;
    }
}

