/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.query;

import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.query.NoSuchOrderException;
import com.raplix.rolloutexpress.persist.query.ObjectOrder;
import java.util.Hashtable;

public class ObjectOrderFactory
implements RPCSerializable {
    private Hashtable mOrderMap;
    private static final ObjectOrder[] EMPTY_ARR = new ObjectOrder[0];

    public ObjectOrderFactory() {
        this.mOrderMap = new Hashtable();
    }

    public ObjectOrderFactory(int expectedSize) {
        this.mOrderMap = new Hashtable(expectedSize);
    }

    void register(ObjectOrder order) {
        String key = order.getName();
        ObjectOrder oldValue = this.mOrderMap.put(key, order);
        if (oldValue != null) {
            this.mOrderMap.put(key, oldValue);
            throw new IllegalArgumentException("order exists: " + key);
        }
    }

    public ObjectOrder getObjectOrder(String name) throws NoSuchOrderException {
        ObjectOrder result = (ObjectOrder)this.mOrderMap.get(name);
        if (result == null) {
            throw new NoSuchOrderException(name);
        }
        return result;
    }

    public ObjectOrder[] getAllObjectOrders() {
        return this.getAllObjectOrders(EMPTY_ARR);
    }

    public ObjectOrder[] getAllObjectOrders(ObjectOrder[] container) {
        return this.mOrderMap.entrySet().toArray(container);
    }
}

