/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.query;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.StandardObject;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.MultiObjectQueryImpl;
import com.raplix.rolloutexpress.persist.query.MultiStandardObjectQuery;
import com.raplix.rolloutexpress.persist.query.ObjectOrderFactory;
import com.raplix.rolloutexpress.persist.query.builder.AndExp;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.EnumColumn;
import com.raplix.rolloutexpress.persist.query.builder.StandardObjectTable;
import com.raplix.rolloutexpress.persist.query.builder.StringColumn;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.util.regex.GlobPattern;

public abstract class MultiStandardObjectQueryImpl
extends MultiObjectQueryImpl
implements MultiStandardObjectQuery {
    private Visibility mVisibilityFilter;
    private GlobPattern mNameFilter;
    private GlobPattern mDescriptionFilter;

    protected MultiStandardObjectQueryImpl(Table table, ConditionalExpression condition, ObjectOrderFactory orderFactory) {
        super(table, condition, orderFactory);
    }

    protected MultiStandardObjectQueryImpl(Table table, ObjectID[] objectIDs, ObjectOrderFactory orderFactory) {
        super(table, objectIDs, orderFactory);
    }

    public Visibility getVisibilityFilter() {
        return this.mVisibilityFilter;
    }

    public void setVisibilityFilter(Visibility visibilityFilter) {
        this.mVisibilityFilter = visibilityFilter;
    }

    public GlobPattern getNameFilter() {
        return this.mNameFilter;
    }

    public void setNameFilter(GlobPattern nameFilter) {
        this.mNameFilter = nameFilter;
    }

    public GlobPattern getDescriptionFilter() {
        return this.mDescriptionFilter;
    }

    public void setDescriptionFilter(GlobPattern descriptionFilter) {
        this.mDescriptionFilter = descriptionFilter;
    }

    public StandardObject[] selectStandardObjectView() throws RPCException, PersistenceManagerException {
        return (StandardObject[])this.selectBeans(StandardObject.class);
    }

    protected ConditionalExpression getFilterCondition(Table t) {
        Visibility visibilityFilter = this.getVisibilityFilter();
        GlobPattern nameFilter = this.getNameFilter();
        GlobPattern descFilter = this.getDescriptionFilter();
        if (visibilityFilter == null && nameFilter == null && descFilter == null) {
            return null;
        }
        AndExp result = t.and();
        if (visibilityFilter != null) {
            result.add(Table.equals(this.getVisibilityColumn(t), visibilityFilter));
        }
        if (nameFilter != null) {
            result.add(Table.likeLower(this.getNameColumn(t), nameFilter));
        }
        if (descFilter != null) {
            result.add(Table.likeLower(this.getDescriptionColumn(t), descFilter));
        }
        return result;
    }

    protected StringColumn getNameColumn(Table t) {
        return ((StandardObjectTable)((Object)t)).cName();
    }

    protected StringColumn getDescriptionColumn(Table t) {
        return ((StandardObjectTable)((Object)t)).cDescription();
    }

    protected EnumColumn getVisibilityColumn(Table t) {
        return t.cVisibility();
    }
}

