/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.query;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.MultiObjectQuery;
import com.raplix.rolloutexpress.persist.query.ObjectFilter;
import com.raplix.rolloutexpress.persist.query.ObjectOrder;
import com.raplix.rolloutexpress.persist.query.ObjectOrderFactory;
import com.raplix.rolloutexpress.persist.query.QueryContext;
import com.raplix.rolloutexpress.persist.query.QueryImplBase;
import com.raplix.rolloutexpress.persist.query.ResultCount;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.OrderByList;
import com.raplix.rolloutexpress.persist.query.builder.QueryBuilder;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.rolloutexpress.persist.query.builder.TableList;
import com.raplix.rolloutexpress.persist.query.builder.WhereClause;
import java.util.Iterator;
import java.util.Vector;

public abstract class MultiObjectQueryImplBase
extends QueryImplBase
implements MultiObjectQuery {
    private ObjectOrderFactory mOrderFactory;
    private ObjectOrder mObjectOrder = null;
    private int mPageSize = -1;
    private int mPageNum = 1;
    private Vector mFilters = new Vector();

    protected MultiObjectQueryImplBase(ObjectOrderFactory orderFactory) {
        this.mOrderFactory = orderFactory;
    }

    public ObjectOrder getObjectOrder() {
        return this.mObjectOrder;
    }

    public void setObjectOrder(ObjectOrder order) {
        this.mObjectOrder = order;
    }

    public ObjectOrderFactory getObjectOrderFactory() {
        return this.mOrderFactory;
    }

    public int getPageSize() {
        return this.mPageSize;
    }

    public void setPageSize(int pageSize) {
        MultiObjectQueryImplBase.validatePageSize(pageSize);
        this.mPageSize = pageSize;
    }

    static void validatePageSize(int pageSize) {
        if (pageSize <= 0 && pageSize != -1) {
            throw new IllegalArgumentException("invalid pageSize: " + pageSize);
        }
    }

    public int getPageNum() {
        return this.mPageNum;
    }

    public void setPageNum(int pageNum) {
        MultiObjectQueryImplBase.validatePageNum(pageNum);
        this.mPageNum = pageNum;
    }

    static void validatePageNum(int pageNum) {
        if (pageNum <= 0) {
            throw new IllegalArgumentException("invalid pageNum: " + pageNum);
        }
    }

    public void addFilter(ObjectFilter filter) {
        this.mFilters.add(filter);
    }

    protected abstract ConditionalExpression getWhereCondition();

    protected abstract TableList getTableList();

    protected abstract SelectList getSelectList();

    public ResultCount selectCount() throws RPCException, PersistenceManagerException {
        QueryContext ctx = this.createQueryContext(null);
        Select query = QueryBuilder.select(QueryBuilder.sList(QB.count()), ctx.getTableList(), ctx.getWhereClause());
        return new ResultCount(this.selectIntResult(this.modifySelect(query)), this.getPageSize(), this.getPageNum());
    }

    public boolean selectExists() throws RPCException, PersistenceManagerException {
        QueryContext ctx = this.createQueryContext(null);
        return this.selectExists(QueryBuilder.select(ctx.getSelectList(), ctx.getTableList(), ctx.getWhereClause()));
    }

    protected Select getSelectStatement() throws RPCException, PersistenceManagerException {
        return this.getSelectStatement(null);
    }

    protected Select getSelectStatement(Object clientContext) throws RPCException, PersistenceManagerException {
        QueryContext ctx = this.createQueryContext(clientContext);
        ObjectOrder order = this.getObjectOrder();
        OrderByList orderByList = null;
        if (order != null) {
            orderByList = order.getOrderByList(ctx);
        }
        WhereClause where = ctx.getWhereClause();
        return QueryBuilder.limit(this.modifySelect(QueryBuilder.select(ctx.getSelectList(), ctx.getTableList(), where, orderByList)), this.getPageSize(), this.getOffset());
    }

    protected Select modifySelect(Select inSelectToModify) {
        return inSelectToModify;
    }

    protected final WhereClause getWhereClause() throws RPCException, PersistenceManagerException {
        QueryContext ctx = this.createQueryContext(null);
        return ctx.getWhereClause();
    }

    protected void addFilterCondition(QueryContext ctx) throws RPCException, PersistenceManagerException {
    }

    protected int getOffset() {
        return this.getPageSize() * (this.getPageNum() - 1);
    }

    protected QueryContext createQueryContext(Object clientContext) throws RPCException, PersistenceManagerException {
        QueryContext ctx = new QueryContext(this.getSelectList(), this.getTableList(), this.getWhereCondition(), clientContext);
        Iterator filters = this.mFilters.iterator();
        while (filters.hasNext()) {
            ObjectFilter filter = (ObjectFilter)filters.next();
            filter.addFilterCondition(ctx);
        }
        this.addFilterCondition(ctx);
        return ctx;
    }

    boolean isBasicQuery() throws RPCException, PersistenceManagerException {
        if (this.getObjectOrder() != null) {
            return false;
        }
        if (this.getPageSize() != -1) {
            return false;
        }
        if (this.mFilters.size() > 0) {
            return false;
        }
        QueryContext ctx = new QueryContext(this.getSelectList(), this.getTableList(), null, null);
        this.addFilterCondition(ctx);
        return ctx.getWhereClause() == null;
    }
}

