/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.query;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.PersistContext;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.RPCTransaction;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.BeanProcessor;
import com.raplix.rolloutexpress.persist.query.MultiObjectQueryImplBase;
import com.raplix.rolloutexpress.persist.query.ObjectOrderFactory;
import com.raplix.rolloutexpress.persist.query.QueryContext;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.QueryBuilder;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.persist.query.builder.TableList;

public abstract class MultiObjectQueryImpl
extends MultiObjectQueryImplBase {
    private Table mTable;
    private ConditionalExpression mWhereCondition;
    private ObjectID[] mObjectIDs;
    private boolean mAddResultsToCache;

    protected MultiObjectQueryImpl(Table table, ConditionalExpression whereCondition, ObjectOrderFactory orderFactory) {
        super(orderFactory);
        this.mTable = table;
        this.mWhereCondition = whereCondition;
    }

    protected MultiObjectQueryImpl(Table table, ObjectID[] objectIDs, ObjectOrderFactory orderFactory) {
        this(table, Table.emptyIn(table.ID, Table.rList(objectIDs)), orderFactory);
        this.mObjectIDs = objectIDs;
    }

    protected Table getTable() {
        return this.mTable;
    }

    protected ConditionalExpression getWhereCondition() {
        return this.mWhereCondition;
    }

    protected ConditionalExpression getFilterCondition(Table t) {
        return null;
    }

    protected void addFilterCondition(QueryContext ctx) throws RPCException, PersistenceManagerException {
        ConditionalExpression exp = this.getFilterCondition((Table)ctx.getTableList().elementAt(0));
        if (exp != null) {
            ctx.addAndWhereCondition(exp);
        }
    }

    protected PersistentBean[] selectBeans(Class arrType) throws RPCException, PersistenceManagerException {
        return (PersistentBean[])this.select(new BeanProcessor(this.getTable(), false), arrType);
    }

    protected Object[] select(BeanProcessor processor, Class type) throws RPCException, PersistenceManagerException {
        processor.setAddResultsToCache(this.getAddResultsToCache());
        if (this.mObjectIDs != null && this.isBasicQuery()) {
            return this.selectByIDs(this.getTable(), this.mObjectIDs, processor, type);
        }
        return this.selectArray(this.getSelectStatement(), processor, type);
    }

    protected int getOffset() {
        return this.getPageSize() * (this.getPageNum() - 1);
    }

    protected TableList getTableList() {
        return QueryBuilder.tList(this.getTable());
    }

    protected SelectList getSelectList() {
        return this.getTable().allColumns();
    }

    protected Select selectIDs() throws RPCException, PersistenceManagerException {
        QueryContext ctx = this.createQueryContext(null);
        return QueryBuilder.select(QueryBuilder.sList(this.getTable().ID), ctx.getTableList(), ctx.getWhereClause());
    }

    protected int updateVisibility(Visibility vis) throws RPCException, PersistenceManagerException {
        Table t = this.getTable().instance();
        VisibilityTransaction tx = new VisibilityTransaction(vis, t, this.selectIDs());
        return ((IntContext)MultiObjectQueryImpl.transactRPC((RPCTransaction)tx)).mValue;
    }

    public boolean getAddResultsToCache() {
        return this.mAddResultsToCache;
    }

    public void setAddResultsToCache(boolean addResultsToCache) {
        this.mAddResultsToCache = addResultsToCache;
    }

    private static class IntContext
    extends PersistContext {
        int mValue;

        private IntContext() {
        }

        IntContext(int value) {
            this.mValue = value;
        }
    }

    private static class VisibilityTransaction
    extends RPCTransaction {
        private Visibility mNewVis;
        private Table mTable;
        private Select mIDs;

        private VisibilityTransaction() {
        }

        public VisibilityTransaction(Visibility vis, Table t, Select ids) {
            this.mNewVis = vis;
            this.mTable = t;
            this.mIDs = ids;
        }

        public PersistContext executeMS() throws PersistenceManagerException {
            this.mTable.checkFolderPerm(this.mIDs);
            int result = this.mTable.updateVisibilityWhere(this.mNewVis, QueryBuilder.where(QueryBuilder.in((ColumnNode)this.mTable.ID, this.mIDs)));
            this.mTable.notifyDependenciesOfUpdate(this.mIDs);
            return new IntContext(result);
        }
    }
}

