/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.query;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.persist.Messages;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.map.ClassMap;
import com.raplix.rolloutexpress.persist.map.exception.ClassMapException;
import com.raplix.rolloutexpress.persist.query.Query;
import com.raplix.rolloutexpress.persist.query.exception.ObjectHasNoIDQueryException;
import com.raplix.rolloutexpress.persist.query.exception.ObjectNotFoundQueryException;
import com.raplix.rolloutexpress.persist.query.exception.QueryException;
import com.raplix.rolloutexpress.persist.sql.SQLStatement;
import com.raplix.util.logger.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;

public class LockObjectQuery
extends Query
implements Messages {
    ObjectID mObjectID;
    ClassMap mClassMap;
    int mSelectCount = 0;

    public LockObjectQuery(ClassMap inClassMap, ObjectID inObjectID) throws ClassMapException {
        super(inClassMap.getDatabase(), false);
        this.mObjectID = inObjectID;
        this.mClassMap = inClassMap;
    }

    protected void prepareToRunQuery() throws ClassMapException, SQLException, QueryException, PersistenceManagerException {
        if (this.mObjectID == null) {
            throw new ObjectHasNoIDQueryException(new ROXMessage("pm.qe.OBJECT_HAS_NO_ID", new String[]{this.mObjectID.toString()}));
        }
    }

    protected SQLStatement generateSQLStatement() throws ClassMapException, PersistenceManagerException {
        SQLStatement sql = new SQLStatement();
        sql.addSQLClause(this.mDatabase.getClauseStringSelect()).addSQLClause(" ");
        sql.addSQLClause("OBJECTID").addSQLClause(" ");
        sql.addSQLClause(this.mDatabase.getClauseStringFrom()).addSQLClause(" ");
        sql.addSQLClause(this.mClassMap.getTableMap().getTableName()).addSQLClause(" ");
        this.mClassMap.addSQLPrimaryKeyWhereClause(sql, this.mObjectID);
        sql.addSQLClause(" ").addSQLClause(this.mDatabase.getClauseStringForUpdate());
        return sql;
    }

    protected void processResultSet(ResultSet inResultSet) throws ClassMapException, SQLException, QueryException, PersistenceManagerException {
        if (inResultSet.next()) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("got:" + inResultSet.getString(1), this);
            }
        } else {
            throw new ObjectNotFoundQueryException(new ROXMessage("pm.qe.OBJECT_NOT_FOUND", this.mObjectID.toString()));
        }
    }

    protected void numRowsUpdated(int numRowsAffected) throws QueryException {
    }

    protected void finalizeQuery() throws ClassMapException, SQLException, QueryException, PersistenceManagerException {
    }
}

