/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.query;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.map.ClassMap;
import com.raplix.rolloutexpress.persist.map.exception.ClassMapException;
import com.raplix.rolloutexpress.persist.query.Query;
import com.raplix.rolloutexpress.persist.query.exception.ObjectHasNoIDQueryException;
import com.raplix.rolloutexpress.persist.query.exception.ObjectNotDeletedQueryException;
import com.raplix.rolloutexpress.persist.query.exception.QueryException;
import com.raplix.rolloutexpress.persist.sql.SQLStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DeleteObjectQuery
extends Query {
    ObjectID mObjectID;
    PersistentBean mFreshObject;
    ClassMap mClassMap;

    public DeleteObjectQuery(ClassMap inClassMap, ObjectID inObjectID) throws ClassMapException {
        super(inClassMap.getDatabase(), true);
        this.mObjectID = inObjectID;
        this.mClassMap = inClassMap;
    }

    protected void prepareToRunQuery() throws ClassMapException, SQLException, QueryException, PersistenceManagerException {
        if (this.mObjectID == null) {
            throw new ObjectHasNoIDQueryException(new ROXMessage("pm.qe.OBJECT_HAS_NO_ID"));
        }
        if (this.mClassMap.getAssociationMaps().size() > 0) {
            this.mFreshObject = this.retrieve(this.mClassMap, this.mObjectID, false);
        }
    }

    protected SQLStatement generateSQLStatement() throws ClassMapException, PersistenceManagerException {
        return this.mClassMap.getDeleteSQLFor(this.mObjectID);
    }

    protected void processResultSet(ResultSet inResultSet) throws ClassMapException, SQLException, QueryException, PersistenceManagerException {
    }

    protected void numRowsUpdated(int numRowsAffected) throws QueryException {
        if (numRowsAffected != 1) {
            throw new ObjectNotDeletedQueryException(new ROXMessage("pm.qe.OBJECT_NOT_DELETED", this.mObjectID.toString()));
        }
        this.mClassMap.removeCacheObject(this.mObjectID);
    }

    protected void finalizeQuery() throws ClassMapException, SQLException, QueryException, PersistenceManagerException {
        if (this.mFreshObject != null) {
            this.forEachAssociation(this.mFreshObject, new Query.Visitor(){

                public void visit(PersistentBean object) throws ClassMapException, SQLException, QueryException, PersistenceManagerException {
                    PersistenceManager.getBeanManager().delete(object);
                }
            });
        }
    }
}

