/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.query;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.persist.query.ResultProcessor;
import com.raplix.rolloutexpress.persist.query.SingleObjectErrorMapper;
import com.raplix.rolloutexpress.persist.query.TooManyResultsFoundException;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import java.sql.ResultSet;
import java.sql.SQLException;

public class BeanProcessor
extends ResultProcessor {
    private Table mTable;
    private boolean mLoadAssociations;
    private int mFlushCount;
    private SingleObjectErrorMapper mErrorMapper = SingleObjectErrorMapper.DEFAULT;
    private boolean mAddResultsToCache;

    protected BeanProcessor() {
    }

    public BeanProcessor(Table table, boolean loadAssociations, boolean isSingleResult) {
        super(isSingleResult);
        this.mTable = table;
        this.mLoadAssociations = loadAssociations;
        this.setAddResultsToCache(isSingleResult);
    }

    public BeanProcessor(Table table, boolean isSingleResult) {
        this(table, true, isSingleResult);
    }

    public Table getTable() {
        return this.mTable;
    }

    protected void prepareToRunQuery() throws PersistenceManagerException {
        if (this.getAddResultsToCache()) {
            this.mFlushCount = this.mTable.getCacheFlushCount();
        }
    }

    private boolean getAddResultsToCache() {
        return this.mAddResultsToCache;
    }

    void setAddResultsToCache(boolean addResultsToCache) {
        this.mAddResultsToCache = addResultsToCache;
    }

    void setErrorMapper(SingleObjectErrorMapper errorMapper) {
        if (errorMapper == null) {
            errorMapper = SingleObjectErrorMapper.DEFAULT;
        }
        this.mErrorMapper = errorMapper;
    }

    public boolean loadAssociations() {
        return this.mLoadAssociations;
    }

    public Object processRow(ResultSet inResultSet) throws PersistenceManagerException, SQLException {
        if (this.getAddResultsToCache()) {
            return this.mTable.retrieveObjectFrom(inResultSet, this.mFlushCount);
        }
        return this.mTable.retrieveObjectFrom(inResultSet);
    }

    public void addResult(PersistentBean inBean) {
        this.mResults.add(inBean);
    }

    protected NoResultsFoundException newNoResultsFoundException() {
        ROXMessage msg = this.mErrorMapper.getNoResultsFoundMessage(this.getTable());
        return new NoResultsFoundException(msg);
    }

    protected TooManyResultsFoundException newTooManyResultsFoundException() {
        ROXMessage msg = this.mErrorMapper.getTooManyResultsFoundMessage(this.getTable());
        return new TooManyResultsFoundException(msg);
    }
}

