/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.map.attribute;

import com.raplix.rolloutexpress.persist.map.ClassMap;
import com.raplix.rolloutexpress.persist.map.attribute.AttributeMap;
import com.raplix.rolloutexpress.persist.map.exception.ClassMapException;
import com.raplix.rolloutexpress.persist.sql.Database;
import com.raplix.rolloutexpress.persist.sql.PostgresSQLDatabase;
import com.raplix.util.logger.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.w3c.dom.Element;

public class StringAttributeMap
extends AttributeMap {
    private static final int DEFAULT_STRING_LENGTH = 256;
    private static final String ATTRIBUTE_NAME_STRING_LENGTH = "stringLength";
    private static final char PM_ESCAPE_CHAR = '|';
    int mStringLength = 256;

    public StringAttributeMap(Element inElement, ClassMap inMappedObjectClassMap) {
        super(inElement, inMappedObjectClassMap);
        String stringLengthStr = inElement.getAttribute(ATTRIBUTE_NAME_STRING_LENGTH);
        if (stringLengthStr != null && stringLengthStr.length() > 0) {
            this.mStringLength = Integer.parseInt(stringLengthStr);
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Creating new String Attribute Map.  StringLength: " + this.mStringLength, this);
        }
    }

    protected String getArrayAsSQLStringImpl(Object inObject) throws ClassMapException {
        Object[] theArray = (String[])this.getValue(inObject);
        return StringAttributeMap.arrayToSQLString(theArray);
    }

    private static String escapeDoubleQuotes(String inString) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < inString.length(); ++i) {
            char ch = inString.charAt(i);
            if (ch == '\"') {
                sb.append('|');
                sb.append("''");
                continue;
            }
            if (ch == '|') {
                sb.append('|');
                sb.append('|');
                continue;
            }
            if (ch == '\'') {
                sb.append('\'');
                sb.append('\'');
                continue;
            }
            if (ch == '\\') {
                sb.append("\\\\\\\\");
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private static String unescapeDoubleQuotes(Database inDB, String str) {
        PostgresSQLDatabase theDB = (PostgresSQLDatabase)inDB;
        boolean backslashesAreEscaped = theDB.getPGMinorVersion() == 2;
        StringBuffer sb = new StringBuffer();
        char[] chars = str.toCharArray();
        block7: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '|': {
                    switch (chars[++i]) {
                        case '\'': {
                            sb.append('\"');
                            continue block7;
                        }
                    }
                    sb.append(chars[i]);
                    continue block7;
                }
                case '\\': {
                    if (backslashesAreEscaped) {
                        sb.append(chars[++i]);
                        continue block7;
                    }
                    sb.append(chars[i]);
                    continue block7;
                }
                default: {
                    sb.append(chars[i]);
                }
            }
        }
        return sb.toString();
    }

    private static String escapeSingleQuotes(String inString) {
        if (inString == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < inString.length(); ++i) {
            char ch = inString.charAt(i);
            if (ch == '\'') {
                sb.append('\'');
                sb.append('\'');
                continue;
            }
            if (ch == '\\') {
                sb.append("\\\\");
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String convertToString(String inString) {
        return StringAttributeMap.escapeSingleQuotes(inString);
    }

    protected String getAsSQLStringImpl(Object inObject) throws ClassMapException {
        return StringAttributeMap.escapeSingleQuotes((String)this.getValue(inObject));
    }

    protected void setArrayValueFromResultSetImpl(Object ioObject, ResultSet inRS, String inColumnName) throws ClassMapException, SQLException {
        String str = inRS.getString(inColumnName);
        String[] stringArray = StringAttributeMap.arrayFromSQLString(this.getDatabase(), str);
        this.setValue(ioObject, stringArray);
    }

    protected void setValueFromResultSetImpl(Object ioObject, ResultSet inRS, String inColumnName) throws ClassMapException, SQLException {
        this.setValue(ioObject, inRS.getString(inColumnName));
    }

    protected void generateSQLColumnType(Database inDatabase, StringBuffer ioBuffer) throws ClassMapException {
        ioBuffer.append(this.getDatabase().getStringColumnType() + "(" + this.mStringLength + ")");
    }

    public static String arrayToSQLString(Object[] inArray) {
        if (inArray == null) {
            return null;
        }
        String theArrayString = " {";
        for (int i = 0; i < inArray.length; ++i) {
            theArrayString = theArrayString + (i > 0 ? ", " : "") + "\"" + StringAttributeMap.escapeDoubleQuotes((String)inArray[i]) + "\"";
        }
        theArrayString = theArrayString + "} ";
        return theArrayString;
    }

    public static String[] arrayFromSQLString(Database inDB, String str) {
        String[] stringArray = null;
        if (str != null && str.trim().length() > 0) {
            Vector<String> stringVector = new Vector<String>();
            int i = str.indexOf("{") + 1;
            while (i > 0 && i < str.length()) {
                String tmp;
                int idx;
                char ch = str.charAt(i);
                if (ch == '\"') {
                    idx = str.indexOf(34, ++i);
                    stringVector.add(StringAttributeMap.unescapeDoubleQuotes(inDB, str.substring(i, idx)));
                    i = idx + 2;
                    continue;
                }
                idx = str.indexOf(44, i);
                if (idx < 0 && (idx = str.indexOf(125, i)) < 0) {
                    idx = str.length();
                }
                if ((tmp = str.substring(i, idx)).trim().length() > 0) {
                    stringVector.add(StringAttributeMap.unescapeDoubleQuotes(inDB, tmp));
                }
                i = idx + 1;
            }
            stringArray = stringVector.toArray(new String[stringVector.size()]);
        }
        return stringArray;
    }
}

