/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.map.attribute;

import com.raplix.rolloutexpress.persist.map.ClassMap;
import com.raplix.rolloutexpress.persist.map.attribute.AttributeMap;
import com.raplix.rolloutexpress.persist.map.exception.ClassMapException;
import com.raplix.rolloutexpress.persist.sql.Database;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.StringTokenizer;
import org.w3c.dom.Element;

public class LongAttributeMap
extends AttributeMap {
    public LongAttributeMap(Element inElement, ClassMap inMappedObjectClassMap) {
        super(inElement, inMappedObjectClassMap);
    }

    protected String getArrayAsSQLStringImpl(Object inObject) throws ClassMapException {
        long[] theArray = (long[])this.getValue(inObject);
        return this.arrayToSQLString(theArray);
    }

    protected String getAsSQLStringImpl(Object inObject) throws ClassMapException {
        Long theValue = (Long)this.getValue(inObject);
        return LongAttributeMap.convertToString(theValue);
    }

    protected void setArrayValueFromResultSetImpl(Object ioObject, ResultSet inRS, String inColumnName) throws ClassMapException, SQLException {
        String theArrayStr = inRS.getString(inColumnName);
        StringTokenizer strTok = new StringTokenizer(theArrayStr, this.getClassMap().getDatabase().getArraySeparatorTokenizer());
        int theArraySize = strTok.countTokens();
        long[] theArrayValue = new long[theArraySize];
        for (int i = 0; i < theArraySize; ++i) {
            String theToken = strTok.nextToken();
            theArrayValue[i] = this.convertFromString(theToken);
        }
        this.setValue(ioObject, theArrayValue);
    }

    protected void setValueFromResultSetImpl(Object ioObject, ResultSet inRS, String inColumnName) throws ClassMapException, SQLException {
        this.setValue(ioObject, new Long(inRS.getLong(inColumnName)));
    }

    protected void generateSQLColumnType(Database inDatabase, StringBuffer ioBuffer) throws ClassMapException {
        ioBuffer.append(this.getDatabase().getLongColumnType());
    }

    public String arrayToSQLString(long[] inArray) {
        String theArrayString = " {";
        for (int i = 0; i < inArray.length; ++i) {
            theArrayString = theArrayString + (i > 0 ? ", " : "") + "\"" + LongAttributeMap.convertToString(inArray[i]) + "\"";
        }
        theArrayString = theArrayString + "} ";
        return theArrayString;
    }

    private long convertFromString(String inStringLong) throws ClassMapException {
        long outValue = Long.parseLong(inStringLong);
        return outValue;
    }

    public static String convertToString(long inLong) {
        return Long.toString(inLong);
    }
}

