/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.map.attribute;

import com.raplix.rolloutexpress.persist.map.ClassMap;
import com.raplix.rolloutexpress.persist.map.attribute.AttributeMap;
import com.raplix.rolloutexpress.persist.map.exception.ClassMapException;
import com.raplix.rolloutexpress.persist.sql.Database;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.StringTokenizer;
import org.w3c.dom.Element;

public class IntAttributeMap
extends AttributeMap {
    public IntAttributeMap(Element inElement, ClassMap inMappedObjectClassMap) {
        super(inElement, inMappedObjectClassMap);
    }

    public IntAttributeMap(ClassMap inMappedObjectClassMap, String inAttributeName, String inColumnName, boolean inIsArray, boolean inIsNullable, boolean inIsUnique, boolean inIsPrimaryKey) {
        super(inMappedObjectClassMap, inAttributeName, inColumnName, inIsArray, inIsNullable, inIsUnique, inIsPrimaryKey);
    }

    protected String getArrayAsSQLStringImpl(Object inObject) throws ClassMapException {
        int[] theArray = (int[])this.getValue(inObject);
        return IntAttributeMap.arrayToSQLString(theArray);
    }

    protected String getAsSQLStringImpl(Object inObject) throws ClassMapException {
        Integer theValue = (Integer)this.getValue(inObject);
        return IntAttributeMap.convertToString(theValue);
    }

    protected void setArrayValueFromResultSetImpl(Object ioObject, ResultSet inRS, String inColumnName) throws ClassMapException, SQLException {
        String theArrayStr = inRS.getString(inColumnName);
        StringTokenizer strTok = new StringTokenizer(theArrayStr, this.getClassMap().getDatabase().getArraySeparatorTokenizer());
        int theArraySize = strTok.countTokens();
        int[] theArrayValue = new int[theArraySize];
        for (int i = 0; i < theArraySize; ++i) {
            String theToken = strTok.nextToken();
            theArrayValue[i] = Integer.parseInt(theToken);
        }
        this.setValue(ioObject, theArrayValue);
    }

    protected void setValueFromResultSetImpl(Object ioObject, ResultSet inRS, String inColumnName) throws ClassMapException, SQLException {
        this.setValue(ioObject, new Integer(inRS.getInt(inColumnName)));
    }

    protected void generateSQLColumnType(Database inDatabase, StringBuffer ioBuffer) throws ClassMapException {
        ioBuffer.append(this.getDatabase().getIntColumnType());
    }

    public static String arrayToSQLString(int[] inArray) {
        String theArrayString = " {";
        for (int i = 0; i < inArray.length; ++i) {
            theArrayString = theArrayString + (i > 0 ? ", " : "") + "\"" + inArray[i] + "\"";
        }
        theArrayString = theArrayString + "} ";
        return theArrayString;
    }

    private int convertFromString(String inStringInt) throws ClassMapException {
        int outValue = Integer.parseInt(inStringInt);
        return outValue;
    }

    public static String convertToString(int inInt) {
        return Integer.toString(inInt);
    }
}

