/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.map.attribute;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.ObjectIDFactory;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.map.ClassMap;
import com.raplix.rolloutexpress.persist.map.attribute.AttributeMap;
import com.raplix.rolloutexpress.persist.map.exception.ClassMapException;
import com.raplix.rolloutexpress.persist.sql.Database;
import com.raplix.util.string.StringUtil;
import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.StringTokenizer;
import org.w3c.dom.Element;

public class IDAttributeMap
extends AttributeMap {
    static final String ATTRIBUTE_NAME_ID_CLASS_NAME = "objectClassName";
    public static final int ID_LENGTH = 56;
    private PersistenceManager mPM = null;
    private String mTargetClassName = null;
    private ClassMap mTargetClassMap;
    private Class mIDClass;

    public IDAttributeMap(Element inElement, ClassMap inMappedObjectClassMap, PersistenceManager inPM) {
        super(inElement, inMappedObjectClassMap);
        this.mTargetClassName = inElement.getAttribute(ATTRIBUTE_NAME_ID_CLASS_NAME);
        this.mPM = inPM;
    }

    public void init() throws ClassMapException {
        super.init();
        if (this.mTargetClassMap == null) {
            if (this.mTargetClassName == null || this.mTargetClassName.trim().length() < 1) {
                throw new ClassMapException(new ROXMessage("pm.idam.NO_ID_CLASS_NAME", new String[]{this.getClassMap().getClassName()}));
            }
            this.mTargetClassMap = this.mPM.getClassMap(this.mTargetClassName);
            if (this.mTargetClassMap == null) {
                throw new ClassMapException(new ROXMessage("pm.idam.NO_ID_CLASS_MAP", new String[]{this.mTargetClassName, this.getClassMap().getClassName()}));
            }
        }
    }

    private Class getIDClass() {
        if (this.mIDClass == null) {
            this.mIDClass = this.mTargetClassMap.getIDFactory().generateObjectID().getClass();
        }
        return this.mIDClass;
    }

    public IDAttributeMap(ClassMap inMappedObjectClassMap, String inAttributeName, String inColumnName, boolean inIsArray, boolean inIsNullable, boolean inIsUnique, boolean inIsPrimaryKey, ClassMap inTargetClassMap) {
        super(inMappedObjectClassMap, inAttributeName, inColumnName, inIsArray, inIsNullable, inIsUnique, inIsPrimaryKey);
        this.mTargetClassMap = inTargetClassMap;
    }

    protected void generateSQLColumnType(Database inDatabase, StringBuffer ioBuffer) throws ClassMapException {
        ioBuffer.append(this.getDatabase().getStringColumnType() + "(" + 56 + ")");
    }

    protected String getAsSQLStringImpl(Object inObject) throws ClassMapException {
        String str = IDAttributeMap.convertToString((ObjectID)this.getValue(inObject));
        return StringUtil.isEmpty(str) ? null : str;
    }

    protected void setArrayValueFromResultSetImpl(Object ioObject, ResultSet inRS, String inColumnName) throws SQLException, ClassMapException {
        String theArrayStr = inRS.getString(inColumnName);
        if (theArrayStr == null || theArrayStr.trim().length() == 0) {
            this.setValue(ioObject, null);
        } else {
            StringTokenizer strTok = new StringTokenizer(theArrayStr, this.getClassMap().getDatabase().getArraySeparatorTokenizer());
            int theArraySize = strTok.countTokens();
            ObjectID[] theArrayValue = (ObjectID[])Array.newInstance(this.getIDClass(), theArraySize);
            for (int i = 0; i < theArraySize; ++i) {
                String theToken = strTok.nextToken();
                theArrayValue[i] = StringUtil.isEmpty(theToken) ? null : this.getIDValue(theToken);
            }
            this.setValue(ioObject, theArrayValue);
        }
    }

    protected String getArrayAsSQLStringImpl(Object inObject) throws ClassMapException {
        ObjectID[] theArray = (ObjectID[])this.getValue(inObject);
        if (theArray == null) {
            return null;
        }
        StringBuffer theArrayString = new StringBuffer(" {");
        for (int i = 0; i < theArray.length; ++i) {
            String str;
            if (i > 0) {
                theArrayString.append(", ");
            }
            theArrayString.append('\"');
            if (theArray[i] != null && !StringUtil.isEmpty(str = IDAttributeMap.convertToString(theArray[i]))) {
                theArrayString.append(str);
            } else {
                theArrayString.append(' ');
            }
            theArrayString.append('\"');
        }
        theArrayString.append("} ");
        return theArrayString.toString();
    }

    protected void setValueFromResultSetImpl(Object ioObject, ResultSet inRS, String inColumnName) throws SQLException, ClassMapException {
        this.setValue(ioObject, this.getIDValue(inRS.getString(inColumnName)));
    }

    private ObjectID getIDValue(String inObjectIDStr) throws ClassMapException {
        return IDAttributeMap.convertFromString(this.mTargetClassMap.getIDFactory(), inObjectIDStr);
    }

    public static ObjectID convertFromString(ObjectIDFactory inIDFactory, String inObjectIDStr) {
        return inObjectIDStr == null ? null : inIDFactory.generateObjectID(inObjectIDStr);
    }

    public static String convertToString(ObjectID inObjectID) {
        return inObjectID == null ? null : inObjectID.toString();
    }

    public ClassMap getMappedClass() {
        return this.mTargetClassMap;
    }
}

