/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.map.attribute;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.persist.Messages;
import com.raplix.rolloutexpress.persist.map.ClassMap;
import com.raplix.rolloutexpress.persist.map.attribute.AttributeMap;
import com.raplix.rolloutexpress.persist.map.exception.ClassMapException;
import com.raplix.rolloutexpress.persist.sql.Database;
import com.raplix.util.enum.Enum;
import com.raplix.util.enum.EnumFactory;
import com.raplix.util.string.StringUtil;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.StringTokenizer;
import org.w3c.dom.Element;

public class EnumAttributeMap
extends AttributeMap
implements Messages {
    static final String ATTRIBUTE_NAME_ENUM_CLASS_NAME = "enumClassName";
    public static final String ENUM_FACTORY_FIELD_NAME = "FACTORY";
    public static final int ID_LENGTH = 56;
    private String mEnumClassName = null;
    private EnumFactory mEnumFactory;
    private Class mEnumClass;

    public EnumAttributeMap(Element inElement, ClassMap inMappedObjectClassMap) {
        super(inElement, inMappedObjectClassMap);
        this.mEnumClassName = inElement.getAttribute(ATTRIBUTE_NAME_ENUM_CLASS_NAME);
    }

    public void init() throws ClassMapException {
        block9: {
            super.init();
            try {
                Field field;
                if (this.mEnumClass == null) {
                    if (this.mEnumClassName == null || this.mEnumClassName.trim().length() < 1) {
                        throw new ClassMapException(new ROXMessage("pm.eam.NO_ENUM_CLASS_NAME", new String[]{this.getAttributeName(), this.getClassMap().getClassName()}));
                    }
                    this.mEnumClass = Class.forName(this.mEnumClassName);
                }
                if (Modifier.isStatic((field = this.mEnumClass.getDeclaredField(ENUM_FACTORY_FIELD_NAME)).getModifiers())) {
                    this.mEnumFactory = (EnumFactory)field.get(null);
                    if (this.mEnumFactory == null) {
                        throw new ClassMapException(new ROXMessage("pm.eam.ENUM_FACTORY_NOT_INIT", new String[]{this.getAttributeName(), this.getClassMap().getClassName()}));
                    }
                    break block9;
                }
                throw new ClassMapException(new ROXMessage("pm.eam.ENUM_FACTORY_NOT_STATIC", new String[]{this.getAttributeName(), this.getClassMap().getClassName()}));
            }
            catch (IllegalAccessException iae) {
                throw new ClassMapException(new ROXMessage("pm.eam.NO_ENUM_FACTORY", new String[]{this.getAttributeName(), this.getClassMap().getClassName()}), (Throwable)iae);
            }
            catch (SecurityException se) {
                throw new ClassMapException(new ROXMessage("pm.eam.NO_ENUM_FACTORY", new String[]{this.getAttributeName(), this.getClassMap().getClassName()}), (Throwable)se);
            }
            catch (NoSuchFieldException nsfe) {
                throw new ClassMapException(new ROXMessage("pm.eam.NO_ENUM_FACTORY", new String[]{this.getAttributeName(), this.getClassMap().getClassName()}), (Throwable)nsfe);
            }
            catch (ClassNotFoundException cnfe) {
                throw new ClassMapException(new ROXMessage("pm.eam.NO_ENUM_FACTORY", new String[]{this.getAttributeName(), this.getClassMap().getClassName()}), (Throwable)cnfe);
            }
        }
    }

    public EnumAttributeMap(ClassMap inMappedObjectClassMap, String inAttributeName, String inColumnName, boolean inIsArray, boolean inIsNullable, boolean inIsUnique, boolean inIsPrimaryKey, Class enumClass) {
        super(inMappedObjectClassMap, inAttributeName, inColumnName, inIsArray, inIsNullable, inIsUnique, inIsPrimaryKey);
        this.mEnumClass = enumClass;
    }

    protected void generateSQLColumnType(Database inDatabase, StringBuffer ioBuffer) throws ClassMapException {
        ioBuffer.append(this.getDatabase().getIntColumnType());
    }

    protected String getAsSQLStringImpl(Object inObject) throws ClassMapException {
        Enum theValue = (Enum)this.getValue(inObject);
        return EnumAttributeMap.convertToString(theValue);
    }

    protected void setArrayValueFromResultSetImpl(Object ioObject, ResultSet inRS, String inColumnName) throws SQLException, ClassMapException {
        String theArrayStr = inRS.getString(inColumnName);
        if (theArrayStr == null || theArrayStr.trim().length() == 0) {
            this.setValue(ioObject, null);
        } else {
            StringTokenizer strTok = new StringTokenizer(theArrayStr, this.getClassMap().getDatabase().getArraySeparatorTokenizer());
            int theArraySize = strTok.countTokens();
            Enum[] theArrayValue = (Enum[])Array.newInstance(this.mEnumClass, theArraySize);
            for (int i = 0; i < theArraySize; ++i) {
                String theToken = strTok.nextToken();
                theArrayValue[i] = StringUtil.isEmpty(theToken) ? null : this.getEnumValue(theToken);
            }
            this.setValue(ioObject, theArrayValue);
        }
    }

    protected String getArrayAsSQLStringImpl(Object inObject) throws ClassMapException {
        Enum[] theArray = (Enum[])this.getValue(inObject);
        if (theArray == null) {
            return null;
        }
        StringBuffer theArrayString = new StringBuffer(" {");
        for (int i = 0; i < theArray.length; ++i) {
            String str;
            if (i > 0) {
                theArrayString.append(", ");
            }
            theArrayString.append('\"');
            if (theArray[i] != null && !StringUtil.isEmpty(str = EnumAttributeMap.convertToString(theArray[i]))) {
                theArrayString.append(str);
            } else {
                theArrayString.append(' ');
            }
            theArrayString.append('\"');
        }
        theArrayString.append("} ");
        return theArrayString.toString();
    }

    protected void setValueFromResultSetImpl(Object ioObject, ResultSet inRS, String inColumnName) throws SQLException, ClassMapException {
        this.setValue(ioObject, this.getEnumValue(inRS.getString(inColumnName)));
    }

    public EnumFactory getEnumFactory() {
        return this.mEnumFactory;
    }

    private Enum getEnumValue(String inStr) {
        return EnumAttributeMap.convertFromString(this.mEnumFactory, inStr);
    }

    public static Enum convertFromString(EnumFactory inFactory, String inStr) {
        return inStr == null ? null : (Enum)inFactory.getEnum(Integer.parseInt(inStr));
    }

    public static String convertToString(Enum inEnum) {
        return inEnum == null ? null : String.valueOf(inEnum.toInt());
    }
}

