/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.map.attribute;

import com.raplix.rolloutexpress.persist.map.ClassMap;
import com.raplix.rolloutexpress.persist.map.attribute.AttributeMap;
import com.raplix.rolloutexpress.persist.map.exception.ClassMapException;
import com.raplix.rolloutexpress.persist.sql.Database;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.StringTokenizer;
import org.w3c.dom.Element;

public class DoubleAttributeMap
extends AttributeMap {
    public static final double NORMALIZED_DOUBLE_MIN = Double.MIN_NORMAL;
    public static final double NORMALIZED_DOUBLE_MAX = 1.79769313486231E308;

    public DoubleAttributeMap(Element inElement, ClassMap inMappedObjectClassMap) {
        super(inElement, inMappedObjectClassMap);
    }

    protected String getArrayAsSQLStringImpl(Object inObject) throws ClassMapException {
        double[] theArray = (double[])this.getValue(inObject);
        return this.arrayToSQLString(theArray);
    }

    protected String getAsSQLStringImpl(Object inObject) throws ClassMapException {
        Double theValue = (Double)this.getValue(inObject);
        return DoubleAttributeMap.convertToString(theValue);
    }

    private double convertFromString(String inStringDouble) throws ClassMapException {
        double outValue = inStringDouble.equals("NaN") ? Double.NaN : Double.parseDouble(inStringDouble);
        return outValue;
    }

    public static String convertToString(double inDouble) {
        return Double.toString(inDouble);
    }

    protected void setArrayValueFromResultSetImpl(Object ioObject, ResultSet inRS, String inColumnName) throws ClassMapException, SQLException {
        String theArrayStr = inRS.getString(inColumnName);
        StringTokenizer strTok = new StringTokenizer(theArrayStr, this.getClassMap().getDatabase().getArraySeparatorTokenizer());
        int theArraySize = strTok.countTokens();
        double[] theArrayValue = new double[theArraySize];
        for (int i = 0; i < theArraySize; ++i) {
            String theToken = strTok.nextToken();
            theArrayValue[i] = this.convertFromString(theToken);
        }
        this.setValue(ioObject, theArrayValue);
    }

    protected void setValueFromResultSetImpl(Object ioObject, ResultSet inRS, String inColumnName) throws ClassMapException, SQLException {
        this.setValue(ioObject, new Double(inRS.getDouble(inColumnName)));
    }

    protected void generateSQLColumnType(Database inDatabase, StringBuffer ioBuffer) throws ClassMapException {
        ioBuffer.append(this.getDatabase().getDoubleColumnType());
    }

    public String arrayToSQLString(double[] inArray) {
        String theArrayString = " {";
        for (int i = 0; i < inArray.length; ++i) {
            theArrayString = theArrayString + (i > 0 ? ", " : "") + "\"" + DoubleAttributeMap.convertToString(inArray[i]) + "\"";
        }
        theArrayString = theArrayString + "} ";
        return theArrayString;
    }
}

