/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.map.attribute;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.persist.Messages;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.map.ClassMap;
import com.raplix.rolloutexpress.persist.map.attribute.AttributeMap;
import com.raplix.rolloutexpress.persist.map.exception.ClassMapException;
import com.raplix.rolloutexpress.persist.sql.Database;
import com.raplix.util.logger.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import java.util.StringTokenizer;
import org.w3c.dom.Element;

public class DateAttributeMap
extends AttributeMap
implements Messages {
    public static final String TIMESTAMP_COLNAME = "C_TIMESTAMP";
    public static final String TIMESTAMP_ATTRIBNAME = "TimeStamp";

    public DateAttributeMap(ClassMap inMappedObjectClassMap, String inAttributeName, String inColumnName, boolean inIsArray, boolean inIsNullable, boolean inIsUnique, boolean inIsPrimaryKey) {
        super(inMappedObjectClassMap, inAttributeName, inColumnName, inIsArray, inIsNullable, inIsUnique, inIsPrimaryKey);
    }

    public DateAttributeMap(Element inElement, ClassMap inMappedObjectClassMap) {
        super(inElement, inMappedObjectClassMap);
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Creating new Date Attribute Map.", this);
        }
    }

    protected String getArrayAsSQLStringImpl(Object inObject) throws ClassMapException {
        Date[] theArray = (Date[])this.getValue(inObject);
        return this.arrayToSQLString(theArray);
    }

    protected String getAsSQLStringImpl(Object inObject) throws ClassMapException {
        return DateAttributeMap.convertToString((Date)this.getValue(inObject));
    }

    protected void setArrayValueFromResultSetImpl(Object ioObject, ResultSet inRS, String inColumnName) throws ClassMapException, SQLException {
        String theArrayStr = inRS.getString(inColumnName);
        StringTokenizer strTok = new StringTokenizer(theArrayStr, this.getClassMap().getDatabase().getArraySeparatorTokenizer());
        int theArraySize = strTok.countTokens();
        Date[] theArrayValue = new Date[theArraySize];
        for (int i = 0; i < theArraySize; ++i) {
            String theToken = strTok.nextToken();
            theArrayValue[i] = DateAttributeMap.convertArrayDateFromString(theToken);
        }
        this.setValue(ioObject, theArrayValue);
    }

    protected void setValueFromResultSetImpl(Object ioObject, ResultSet inRS, String inColumnName) throws ClassMapException, SQLException {
        this.setValue(ioObject, DateAttributeMap.getDate(inRS, inColumnName));
    }

    protected void generateSQLColumnType(Database inDatabase, StringBuffer ioBuffer) throws ClassMapException {
        ioBuffer.append(this.getDatabase().getDateColumnType());
    }

    private String arrayToSQLString(Date[] inArray) {
        String theArrayString = " {";
        for (int i = 0; i < inArray.length; ++i) {
            theArrayString = theArrayString + (i > 0 ? ", " : "") + "\"" + DateAttributeMap.convertToString(inArray[i]) + "\"";
        }
        theArrayString = theArrayString + "} ";
        return theArrayString;
    }

    public static Date convertFromString(String inStringDate) throws ClassMapException {
        if (inStringDate == null) {
            return null;
        }
        try {
            return DateAttributeMap.fixTimeStamp(Timestamp.valueOf(inStringDate));
        }
        catch (IllegalArgumentException e) {
            throw new ClassMapException(new ROXMessage("pm.dam.SQL_DATE_PARSE_ERROR"), (Throwable)e, 1);
        }
    }

    public static Date convertArrayDateFromString(String inStringDate) throws ClassMapException {
        try {
            return PersistenceManager.getInstance().getDefaultDatabase().getDateFormat().parse(inStringDate);
        }
        catch (ParseException e) {
            throw new ClassMapException(new ROXMessage("pm.dam.SQL_DATE_PARSE_ERROR"), (Throwable)e, 1);
        }
    }

    public static String convertToString(Date inDate) {
        if (inDate == null) {
            return null;
        }
        Timestamp theTS = new Timestamp(inDate.getTime());
        if (Logger.isDebugEnabled(DateAttributeMap.class)) {
            Logger.debug("Converting Timestamp " + inDate + ":ts:" + theTS, DateAttributeMap.class);
        }
        return theTS.toString();
    }

    public static Date getDate(ResultSet inRS, String inColumnName) throws SQLException {
        String str = inRS.getString(inColumnName);
        if (str != null) {
            return DateAttributeMap.fixTimeStamp(Timestamp.valueOf(str));
        }
        return null;
    }

    public static Date getDate(ResultSet inRS, int inColumnIndex) throws SQLException {
        String str = inRS.getString(inColumnIndex);
        if (str != null) {
            return DateAttributeMap.fixTimeStamp(Timestamp.valueOf(str));
        }
        return null;
    }

    public static Date fixTimeStamp(Timestamp inTS) {
        return new Date(inTS.getTime());
    }

    public void init() throws ClassMapException {
        super.init();
        if (this.isArray()) {
            throw new ClassMapException(new ROXMessage("pm.dam.DATE_ARRAYS_NOT_SUPPORTED"));
        }
    }
}

