/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.map.attribute;

import com.raplix.rolloutexpress.persist.map.ClassMap;
import com.raplix.rolloutexpress.persist.map.attribute.AttributeMap;
import com.raplix.rolloutexpress.persist.map.exception.ClassMapException;
import com.raplix.rolloutexpress.persist.sql.Database;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.StringTokenizer;
import org.w3c.dom.Element;

public class BooleanAttributeMap
extends AttributeMap {
    public BooleanAttributeMap(Element inElement, ClassMap inMappedObjectClassMap) {
        super(inElement, inMappedObjectClassMap);
    }

    protected String getArrayAsSQLStringImpl(Object inObject) throws ClassMapException {
        boolean[] theArray = (boolean[])this.getValue(inObject);
        return this.arrayToSQLString(theArray);
    }

    protected String getAsSQLStringImpl(Object inObject) throws ClassMapException {
        Boolean theValue = (Boolean)this.getValue(inObject);
        return BooleanAttributeMap.convertToString(theValue);
    }

    protected void setArrayValueFromResultSetImpl(Object ioObject, ResultSet inRS, String inColumnName) throws ClassMapException, SQLException {
        String theArrayStr = inRS.getString(inColumnName);
        StringTokenizer strTok = new StringTokenizer(theArrayStr, this.getClassMap().getDatabase().getArraySeparatorTokenizer());
        int theArraySize = strTok.countTokens();
        boolean[] theArrayValue = new boolean[theArraySize];
        for (int i = 0; i < theArraySize; ++i) {
            String theToken = strTok.nextToken();
            theArrayValue[i] = this.convertFromString(theToken);
        }
        this.setValue(ioObject, theArrayValue);
    }

    protected void setValueFromResultSetImpl(Object ioObject, ResultSet inRS, String inColumnName) throws ClassMapException, SQLException {
        this.setValue(ioObject, new Boolean(inRS.getBoolean(inColumnName)));
    }

    protected void generateSQLColumnType(Database inDatabase, StringBuffer ioBuffer) throws ClassMapException {
        ioBuffer.append(this.getDatabase().getBooleanColumnType());
    }

    public String arrayToSQLString(boolean[] inArray) {
        String theArrayString = " {";
        for (int i = 0; i < inArray.length; ++i) {
            theArrayString = theArrayString + (i > 0 ? ", " : "") + "\"" + BooleanAttributeMap.convertToString(inArray[i]) + "\"";
        }
        theArrayString = theArrayString + "} ";
        return theArrayString;
    }

    private boolean convertFromString(String inStringBoolean) throws ClassMapException {
        boolean outValue = false;
        if (inStringBoolean != null && (inStringBoolean.equals("true") || inStringBoolean.equals("t"))) {
            outValue = true;
        }
        return outValue;
    }

    public static String convertToString(boolean inBoolean) {
        boolean theBoolean = inBoolean;
        String outValue = theBoolean ? "true" : "false";
        return outValue;
    }
}

