/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.map.attribute;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.persist.Messages;
import com.raplix.rolloutexpress.persist.map.ClassMap;
import com.raplix.rolloutexpress.persist.map.attribute.AttributeAccesser;
import com.raplix.rolloutexpress.persist.map.exception.ClassMapException;
import com.raplix.rolloutexpress.persist.sql.Database;
import com.raplix.util.logger.Logger;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.w3c.dom.Element;

public abstract class AttributeMap
implements Messages {
    public static final String SETTER_PREFIX = "set";
    public static final String GETTER_PREFIX = "get";
    public static final String BOOLEAN_GETTER_PREFIX = "is";
    public static final String MEMBER_PREFIX = "m";
    static final String ATTRIBUTE_NAME_ATTRIBUTE_NAME = "attributeName";
    static final String ATTRIBUTE_NAME_COLUMN_NAME = "columnName";
    static final String ATTRIBUTE_NAME_IS_ARRAY = "isArray";
    static final String ATTRIBUTE_NAME_IS_UNIQUE = "unique";
    static final String ATTRIBUTE_NAME_IS_PRIMARY_KEY = "primaryKey";
    static final String ATTRIBUTE_NAME_IS_NULLABLE = "nullable";
    static final String ATTRIBUTE_NAME_IS_NOT_AUTO = "noAuto";
    private String mAttributeName;
    private String mColumnName;
    private ClassMap mClassMap;
    private boolean mIsArray;
    private boolean mIsNullable;
    private boolean mIsUnique;
    private boolean mIsPrimaryKey;
    private boolean mIsNotAuto;
    protected AttributeAccesser mGetter = null;
    protected AttributeAccesser mSetter = null;

    public AttributeMap(Element inElement, ClassMap inMappedObjectClassMap) {
        this.mAttributeName = inElement.getAttribute(ATTRIBUTE_NAME_ATTRIBUTE_NAME);
        this.mColumnName = inElement.getAttribute(ATTRIBUTE_NAME_COLUMN_NAME);
        this.mClassMap = inMappedObjectClassMap;
        this.mIsArray = this.retrieveBooleanAttribute(inElement, ATTRIBUTE_NAME_IS_ARRAY);
        this.mIsNullable = this.retrieveBooleanAttribute(inElement, ATTRIBUTE_NAME_IS_NULLABLE);
        this.mIsUnique = this.retrieveBooleanAttribute(inElement, ATTRIBUTE_NAME_IS_UNIQUE);
        this.mIsPrimaryKey = this.retrieveBooleanAttribute(inElement, ATTRIBUTE_NAME_IS_PRIMARY_KEY);
        this.mIsNotAuto = this.retrieveBooleanAttribute(inElement, ATTRIBUTE_NAME_IS_NOT_AUTO);
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Creating new Attribute Map.  AttributeName: " + this.mAttributeName + " ColumnName: " + this.mColumnName + " isArray " + this.mIsArray + "Is Unquie " + this.mIsUnique + " Is Primary KEy " + this.mIsPrimaryKey + " is nullable " + this.mIsNullable, this);
        }
    }

    protected AttributeMap(ClassMap inMappedObjectClassMap, String inAttributeName, String inColumnName, boolean inIsArray, boolean inIsNullable, boolean inIsUnique, boolean inIsPrimaryKey) {
        this.mAttributeName = inAttributeName;
        this.mColumnName = inColumnName;
        this.mClassMap = inMappedObjectClassMap;
        this.mIsArray = inIsArray;
        this.mIsNullable = inIsNullable;
        this.mIsUnique = inIsUnique;
        this.mIsPrimaryKey = inIsPrimaryKey;
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Creating new Attribute Map.  AttributeName: " + this.mAttributeName + " ColumnName: " + this.mColumnName + " isArray " + this.mIsArray + "Is Unquie " + this.mIsUnique + " Is Primary KEy " + this.mIsPrimaryKey + " is nullable " + this.mIsNullable, this);
        }
    }

    protected boolean retrieveBooleanAttribute(Element inElement, String inAttributeName) {
        String outAttribute = inElement.getAttribute(inAttributeName);
        return outAttribute == null ? false : outAttribute.toLowerCase().equals("true");
    }

    public void init() throws ClassMapException {
        this.initGetter(this.mClassMap.getMappedClass());
        this.initSetter(this.mClassMap.getMappedClass());
    }

    public void setValueFromResultSet(Object ioObject, ResultSet inRS, String inColumnName) throws ClassMapException, SQLException {
        if (this.isArray()) {
            this.setArrayValueFromResultSetImpl(ioObject, inRS, inColumnName);
        } else {
            this.setValueFromResultSetImpl(ioObject, inRS, inColumnName);
        }
    }

    public String getAsSQLString(Object inObject) throws ClassMapException {
        String returnValue = this.isArray() ? this.getArrayAsSQLStringImpl(inObject) : this.getAsSQLStringImpl(inObject);
        if (returnValue != null) {
            returnValue = "'" + returnValue + "'";
        }
        return returnValue;
    }

    public void generateSQLColumnDefinition(Database inDatabase, StringBuffer ioBuffer) throws ClassMapException {
        ioBuffer.append(this.getColumnName() + "\t");
        this.generateSQLColumnType(inDatabase, ioBuffer);
        if (this.isArray()) {
            ioBuffer.append("[]");
        }
    }

    public String getAttributeName() {
        return this.mAttributeName;
    }

    public String getColumnName() {
        return this.mColumnName;
    }

    public String getFullyQualifiedColumnName() {
        return this.getClassMap().getTableMap().getTableName() + "." + this.getColumnName();
    }

    public ClassMap getClassMap() {
        return this.mClassMap;
    }

    protected Database getDatabase() {
        return this.getClassMap().getDatabase();
    }

    public boolean isArray() {
        return this.mIsArray;
    }

    public boolean isNotAuto() {
        return this.mIsNotAuto;
    }

    protected abstract void setValueFromResultSetImpl(Object var1, ResultSet var2, String var3) throws ClassMapException, SQLException;

    protected abstract void setArrayValueFromResultSetImpl(Object var1, ResultSet var2, String var3) throws ClassMapException, SQLException;

    protected abstract String getAsSQLStringImpl(Object var1) throws ClassMapException;

    protected abstract String getArrayAsSQLStringImpl(Object var1) throws ClassMapException;

    protected abstract void generateSQLColumnType(Database var1, StringBuffer var2) throws ClassMapException;

    protected void initGetter(Class inMappedObjectClass) throws ClassMapException {
        Method theGetterMethod = null;
        try {
            theGetterMethod = this.retrieveMethod(inMappedObjectClass, GETTER_PREFIX + this.mAttributeName, new Class[0]);
            this.mGetter = new AttributeAccesser(theGetterMethod);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (this.mGetter == null) {
            try {
                theGetterMethod = this.retrieveMethod(inMappedObjectClass, BOOLEAN_GETTER_PREFIX + this.mAttributeName, new Class[0]);
                this.mGetter = new AttributeAccesser(theGetterMethod);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        Field theGetterField = null;
        if (this.mGetter == null) {
            try {
                theGetterField = AttributeMap.retrieveField(inMappedObjectClass, MEMBER_PREFIX + this.mAttributeName);
                this.mGetter = new AttributeAccesser(theGetterField);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.mGetter == null) {
            throw new ClassMapException(new ROXMessage("pm.am.NO_GETTER_METHOD", new String[]{this.getAttributeName(), inMappedObjectClass.getName()}));
        }
    }

    protected void initSetter(Class inMappedObjectClass) throws ClassMapException {
        Class[] setterParameters = new Class[]{this.mGetter.getReturnType()};
        Method theSetterMethod = null;
        try {
            theSetterMethod = this.retrieveMethod(inMappedObjectClass, SETTER_PREFIX + this.mAttributeName, setterParameters);
            this.mSetter = new AttributeAccesser(theSetterMethod);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        Field theSetterField = null;
        if (this.mSetter == null) {
            theSetterField = AttributeMap.retrieveField(inMappedObjectClass, MEMBER_PREFIX + this.mAttributeName);
            this.mSetter = new AttributeAccesser(theSetterField);
        }
        if (this.mSetter == null) {
            throw new ClassMapException(new ROXMessage("pm.am.NO_SETTER_METHOD", new String[]{this.getAttributeName(), inMappedObjectClass.getName()}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Field retrieveField(Class inClass, String inFieldName) {
        Field currField = null;
        Class currClass = inClass;
        while (currField == null && currClass != null) {
            try {
                currField = currClass.getDeclaredField(inFieldName);
            }
            catch (NoSuchFieldException e) {}
            continue;
            finally {
                currClass = currClass.getSuperclass();
            }
        }
        currField.setAccessible(true);
        return currField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method retrieveMethod(Class inClass, String inMethodName, Class[] inParameterTypes) throws NoSuchMethodException {
        Method currMethod = null;
        Class currClass = inClass;
        while (currMethod == null && currClass != null) {
            try {
                currMethod = currClass.getDeclaredMethod(inMethodName, inParameterTypes);
            }
            catch (NoSuchMethodException e) {}
            continue;
            finally {
                currClass = currClass.getSuperclass();
            }
        }
        if (currMethod == null) {
            ROXMessage theMessage = new ROXMessage("pm.METHOD_NOT_FOUND", new String[]{inClass + "." + inMethodName + ":" + inParameterTypes.length});
            throw new NoSuchMethodException(theMessage.getMessageString());
        }
        currMethod.setAccessible(true);
        return currMethod;
    }

    public Object getValue(Object inObject) throws ClassMapException {
        Object value = null;
        try {
            value = this.mGetter.get(inObject);
        }
        catch (Exception e) {
            throw new ClassMapException(new ROXMessage("pm.am.CANT_INVOKE_GETTER", new String[]{this.mAttributeName, this.mClassMap.getClassName()}), (Throwable)e, 1);
        }
        return value;
    }

    public void setValue(Object ioObject, Object inValue) throws ClassMapException {
        try {
            this.mSetter.set(ioObject, inValue);
        }
        catch (Exception e) {
            throw new ClassMapException(new ROXMessage("pm.am.CANT_INVOKE_SETTER", new String[]{this.mAttributeName, this.mClassMap.getClassName()}), (Throwable)e, 1);
        }
    }

    public void copyValue(Object fromObject, Object toObject) throws ClassMapException {
        if (!this.isArray()) {
            this.setValue(toObject, this.getValue(fromObject));
        } else {
            Object obj = this.getValue(fromObject);
            Object newArray = null;
            if (obj != null) {
                int length = Array.getLength(obj);
                newArray = Array.newInstance(obj.getClass().getComponentType(), length);
                System.arraycopy(obj, 0, newArray, 0, length);
            }
            this.setValue(toObject, newArray);
        }
    }

    public String toString() {
        return "AttribMap:" + this.mAttributeName + ":Col:" + this.mColumnName + ":Array:" + this.mIsArray + ":Nullable:" + this.mIsNullable + ":PrimaryKey:" + this.mIsPrimaryKey + ":Unique:" + this.mIsUnique;
    }
}

