/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.map.attribute;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.persist.Messages;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.PersistentObject;
import com.raplix.rolloutexpress.persist.map.ClassMap;
import com.raplix.rolloutexpress.persist.map.attribute.AttributeMap;
import com.raplix.rolloutexpress.persist.map.exception.ClassMapException;
import com.raplix.rolloutexpress.persist.sql.Database;
import com.raplix.util.logger.Logger;
import com.raplix.util.string.StringUtil;
import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.StringTokenizer;
import org.w3c.dom.Element;

public class AssociationAttributeMap
extends AttributeMap
implements Messages {
    static final String ATTRIBUTE_NAME_ASSOCIATION_CLASS_NAME = "associationClassName";
    static final String ATTRIBUTE_NAME_IS_LAZY_FETCH = "lazyFetch";
    private ClassMap mTargetClassMap;
    private String mTargetClassName;
    private boolean mIsLazyFetch = true;
    private PersistenceManager mPM;

    public ClassMap getTargetClassMap() {
        return this.mTargetClassMap;
    }

    public AssociationAttributeMap(Element inElement, ClassMap inMappedObjectClassMap, PersistenceManager inPM) {
        super(inElement, inMappedObjectClassMap);
        this.mTargetClassName = inElement.getAttribute(ATTRIBUTE_NAME_ASSOCIATION_CLASS_NAME);
        this.mIsLazyFetch = this.retrieveBooleanAttribute(inElement, ATTRIBUTE_NAME_IS_LAZY_FETCH);
        this.mPM = inPM;
    }

    public void init() throws ClassMapException {
        super.init();
        if (this.mTargetClassName == null) {
            throw new ClassMapException(new ROXMessage("pm.aam.NO_CLASS_NAME", new String[]{this.getClassMap().getClassName()}));
        }
        this.mTargetClassMap = this.mPM.getClassMap(this.mTargetClassName);
        if (this.mTargetClassMap == null) {
            throw new ClassMapException(new ROXMessage("pm.aam.NO_CLASS_MAP_FOR_ASSOCATION", new String[]{this.getClassMap().getClassName()}));
        }
    }

    protected String getAsSQLStringImpl(Object inObject) throws ClassMapException {
        PersistentObject theTarget = (PersistentObject)this.getValue(inObject);
        ObjectID objID = null;
        if (theTarget == null || (objID = theTarget.getObjectID()) == null) {
            return null;
        }
        String str = objID.toString();
        return StringUtil.isEmpty(str) ? null : str;
    }

    protected String getArrayAsSQLStringImpl(Object inObject) throws ClassMapException {
        PersistentObject[] theArray = (PersistentObject[])this.getValue(inObject);
        if (theArray == null) {
            return null;
        }
        StringBuffer theArrayString = new StringBuffer(" {");
        for (int i = 0; i < theArray.length; ++i) {
            String str;
            if (i > 0) {
                theArrayString.append(", ");
            }
            theArrayString.append('\"');
            if (theArray[i] != null && theArray[i].getObjectID() != null && !StringUtil.isEmpty(str = theArray[i].getObjectID().toString())) {
                theArrayString.append(str);
            } else {
                theArrayString.append(' ');
            }
            theArrayString.append('\"');
        }
        theArrayString.append("} ");
        return theArrayString.toString();
    }

    protected void setValueFromResultSetImpl(Object ioObject, ResultSet inRS, String inColumnName) throws ClassMapException, SQLException {
        try {
            String theIDStr = inRS.getString(inColumnName);
            if (theIDStr != null) {
                ObjectID theID = this.getTargetClassMap().getIDFactory().generateObjectID(theIDStr);
                PersistentObject theTarget = (PersistentObject)this.getTargetClassMap().newInstance();
                theTarget.setObjectID(theID);
                this.setValue(ioObject, theTarget);
            } else {
                this.setValue(ioObject, null);
            }
        }
        catch (Exception e) {
            ROXMessage theMessage = new ROXMessage("pm.aam.ERROR_DURING_SET", new String[]{this.getAttributeName()});
            if (Logger.isErrorEnabled(this)) {
                Logger.error(theMessage.getMessageString(), e, this);
            }
            throw new ClassMapException(theMessage, (Throwable)e, 1);
        }
    }

    protected void setArrayValueFromResultSetImpl(Object ioObject, ResultSet inRS, String inColumnName) throws ClassMapException, SQLException {
        try {
            String theArrayStr = inRS.getString(inColumnName);
            if (theArrayStr == null || theArrayStr.trim().length() == 0) {
                this.setValue(ioObject, null);
            } else {
                StringTokenizer strTok = new StringTokenizer(theArrayStr, this.getClassMap().getDatabase().getArraySeparatorTokenizer());
                int theArraySize = strTok.countTokens();
                PersistentObject[] theArrayValue = (PersistentObject[])Array.newInstance(this.getTargetClassMap().getMappedClass(), theArraySize);
                for (int i = 0; i < theArraySize; ++i) {
                    String theToken = strTok.nextToken();
                    if (StringUtil.isEmpty(theToken)) {
                        theArrayValue[i] = null;
                        continue;
                    }
                    theArrayValue[i] = (PersistentObject)this.getTargetClassMap().newInstance();
                    ObjectID theID = this.getTargetClassMap().getIDFactory().generateObjectID(theToken);
                    theArrayValue[i].setObjectID(theID);
                }
                this.setValue(ioObject, theArrayValue);
            }
        }
        catch (Exception e) {
            ROXMessage theMessage = new ROXMessage("pm.aam.ERROR_DURING_ARRAY_SET", new String[]{this.getAttributeName()});
            if (Logger.isErrorEnabled(this)) {
                Logger.error(theMessage.getMessageString(), e, this);
            }
            throw new ClassMapException(theMessage, (Throwable)e, 1);
        }
    }

    protected void generateSQLColumnType(Database inDatabase, StringBuffer ioBuffer) throws ClassMapException {
        ioBuffer.append(ObjectID.generateSQLColumnTypeDefinition(inDatabase));
    }

    public ClassMap getMappedClass() {
        return this.mTargetClassMap;
    }

    public void copyValue(Object fromObject, Object toObject) throws ClassMapException {
        if (!this.isArray()) {
            Object obj = this.getValue(fromObject);
            if (obj != null) {
                obj = this.createEmptyMappedObject((PersistentObject)obj);
            }
            this.setValue(toObject, obj);
        } else {
            Object obj = this.getValue(fromObject);
            Object newArray = null;
            if (obj != null) {
                int length = Array.getLength(obj);
                newArray = Array.newInstance(obj.getClass().getComponentType(), length);
                for (int i = 0; i < length; ++i) {
                    Object tmp = Array.get(obj, i);
                    if (tmp != null) {
                        tmp = this.createEmptyMappedObject((PersistentObject)tmp);
                    }
                    Array.set(newArray, i, tmp);
                }
            }
            this.setValue(toObject, newArray);
        }
    }

    private PersistentBean createEmptyMappedObject(PersistentObject obj) throws ClassMapException {
        PersistentBean po = this.getTargetClassMap().newInstance();
        this.getClassMap().getBeanManager().setObjectID(po, this.getClassMap().getBeanManager().getObjectID(obj));
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Created empty object for:" + obj.getObjectID(), this);
        }
        return po;
    }
}

