/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.map;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.Subsystem;
import com.raplix.rolloutexpress.net.NetSubsystem;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.map.ClassMap;
import com.raplix.rolloutexpress.persist.map.TableMap;
import com.raplix.rolloutexpress.persist.map.attribute.AssociationAttributeMap;
import com.raplix.rolloutexpress.persist.map.attribute.BooleanAttributeMap;
import com.raplix.rolloutexpress.persist.map.attribute.DateAttributeMap;
import com.raplix.rolloutexpress.persist.map.attribute.DoubleAttributeMap;
import com.raplix.rolloutexpress.persist.map.attribute.EnumAttributeMap;
import com.raplix.rolloutexpress.persist.map.attribute.FloatAttributeMap;
import com.raplix.rolloutexpress.persist.map.attribute.IDAttributeMap;
import com.raplix.rolloutexpress.persist.map.attribute.IntAttributeMap;
import com.raplix.rolloutexpress.persist.map.attribute.LongAttributeMap;
import com.raplix.rolloutexpress.persist.map.attribute.StringAttributeMap;
import com.raplix.rolloutexpress.persist.map.exception.ClassMapException;
import com.raplix.rolloutexpress.persist.sql.Database;
import com.raplix.util.logger.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class MapXMLReader {
    PersistenceManager mPM;
    List mInputStreamList = Collections.synchronizedList(new ArrayList());
    Database mDatabase;
    boolean mDisableVerficiation;
    static final String NODE_NAME_TABLE_MAP_LIST = "TableMapList";
    static final String NODE_NAME_TABLE_MAP = "TableMap";
    static final String NODE_NAME_CLASS_MAP_LIST = "ClassMapList";
    static final String NODE_NAME_CLASS_MAP = "ClassMap";
    static final String NODE_NAME_ASSOCIATION_ATTRIBUTE_MAP = "AssociationMap";
    static final String NODE_NAME_ID_ATTRIBUTE_MAP = "IDMap";
    static final String NODE_NAME_STRING_ATTRIBUTE_MAP = "StringMap";
    static final String NODE_NAME_BOOLEAN_ATTRIBUTE_MAP = "BooleanMap";
    static final String NODE_NAME_INT_ATTRIBUTE_MAP = "IntMap";
    static final String NODE_NAME_LONG_ATTRIBUTE_MAP = "LongMap";
    static final String NODE_NAME_FLOAT_ATTRIBUTE_MAP = "FloatMap";
    static final String NODE_NAME_DOUBLE_ATTRIBUTE_MAP = "DoubleMap";
    static final String NODE_NAME_DATE_ATTRIBUTE_MAP = "DateMap";
    static final String NODE_NAME_ENUM_ATTRIBUTE_MAP = "EnumMap";
    static final String ATTRIBUTE_NAME_NAME = "name";
    static final String ATTRIBUTE_NAME_CLASS_MAP_CLASS_NAME = "className";
    static final String ATTRIBUTE_NAME_CLASS_MAP_ID_FACTORY_CLASS_NAME = "idFactoryClassName";
    static final String ATTRIBUTE_NAME_TABLE_MAP_NAME = "tableMap";
    static final String ATTRIBUTE_NAME_TABLE_NAME = "tableName";
    static final String ATTRIBUTE_NAME_PERMISSION_NAME = "permissionName";
    static final String ATTRIBUTE_NAME_TABLE_BASE_CLASS_NAME = "tableBaseClass";
    static final String ATTRIBUTE_NAME_TABLE_INTERFACES_NAME = "tableInterfaces";
    static final String ATTRIBUTE_NAME_DISABLE_LOCKING = "disableLocking";
    static final String ATTRIBUTE_NAME_PRE_LOCKING = "preLocking";
    static final String ATTRIBUTE_NAME_ENABLE_CACHING = "enableCaching";
    static final String ATTRIBUTE_NAME_CLONE_CACHE_OBJ = "cloneCacheObjects";
    static final String ATTRIBUTE_NAME_ALLOW_REMOTE_SAVE_OBJECT = "allowRemoteSaveObject";
    static final String ATTRIBUTE_NAME_ALLOW_REMOTE_DELETE_OBJECT = "allowRemoteDeleteObject";
    static final String ATTRIBUTE_NAME_ALLOW_SESSION_DELETE = "allowSessionDelete";
    static /* synthetic */ Class class$com$raplix$rolloutexpress$persist$PersistenceManager;

    public MapXMLReader(PersistenceManager ioPM, InputStream inInputStream, boolean inDisableClassMapVerification) {
        this(ioPM, new InputStream[]{inInputStream}, inDisableClassMapVerification);
    }

    public MapXMLReader(PersistenceManager ioPM, InputStream[] inInputStreams, boolean inDisableClassMapVerification) {
        this.mPM = ioPM;
        for (int x = 0; x < inInputStreams.length; ++x) {
            this.mInputStreamList.add(inInputStreams[x]);
        }
        this.mDisableVerficiation = inDisableClassMapVerification;
    }

    public void readFromXML() throws ClassMapException {
        DOMParser parser = new DOMParser();
        try {
            parser.setFeature("http://xml.org/sax/features/validation", false);
            parser.setFeature("http://xml.org/sax/features/namespaces", false);
        }
        catch (Exception e) {
            // empty catch block
        }
        Iterator it = this.mInputStreamList.iterator();
        while (it.hasNext()) {
            Node topElement;
            block7: {
                topElement = null;
                try {
                    parser.parse(new InputSource((InputStream)it.next()));
                    topElement = parser.getDocument().getDocumentElement();
                }
                catch (Exception e) {
                    if (!Logger.isErrorEnabled(this)) break block7;
                    Logger.error("Error trying to parse mapping files", e, this);
                }
            }
            if (Logger.isDebugEnabled(this)) {
                Logger.debug(topElement.getNodeName(), this);
            }
            NodeList children = topElement.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 1 || !child.getNodeName().equalsIgnoreCase(NODE_NAME_CLASS_MAP_LIST)) continue;
                this.parseClassMapList((Element)child);
            }
        }
        this.mPM.initializeClassMaps(this.mDisableVerficiation);
    }

    private void parseClassMapList(Element inClassMapListElement) throws ClassMapException {
        NodeList tableMaps = inClassMapListElement.getChildNodes();
        for (int i = 0; i < tableMaps.getLength(); ++i) {
            Node child = tableMaps.item(i);
            if (child.getNodeType() != 1 || !child.getNodeName().equals(NODE_NAME_CLASS_MAP)) continue;
            this.parseClassMap((Element)child);
        }
    }

    private void parseClassMap(Element inClassMap) throws ClassMapException {
        String className = inClassMap.getAttribute(ATTRIBUTE_NAME_CLASS_MAP_CLASS_NAME);
        String tableName = inClassMap.getAttribute(ATTRIBUTE_NAME_TABLE_NAME);
        String idFactoryClassName = inClassMap.getAttribute(ATTRIBUTE_NAME_CLASS_MAP_ID_FACTORY_CLASS_NAME);
        String permissionName = inClassMap.getAttribute(ATTRIBUTE_NAME_PERMISSION_NAME);
        String tableBaseClassName = inClassMap.getAttribute(ATTRIBUTE_NAME_TABLE_BASE_CLASS_NAME);
        String tableInterfacesNames = inClassMap.getAttribute(ATTRIBUTE_NAME_TABLE_INTERFACES_NAME);
        String disableLocking = inClassMap.getAttribute(ATTRIBUTE_NAME_DISABLE_LOCKING);
        String preLocking = inClassMap.getAttribute(ATTRIBUTE_NAME_PRE_LOCKING);
        String enableCaching = inClassMap.getAttribute(ATTRIBUTE_NAME_ENABLE_CACHING);
        String cloneCacheObjects = inClassMap.getAttribute(ATTRIBUTE_NAME_CLONE_CACHE_OBJ);
        String allowRemoteSaveObject = inClassMap.getAttribute(ATTRIBUTE_NAME_ALLOW_REMOTE_SAVE_OBJECT);
        String allowRemoteDeleteObject = inClassMap.getAttribute(ATTRIBUTE_NAME_ALLOW_REMOTE_DELETE_OBJECT);
        String allowSessionDelete = inClassMap.getAttribute(ATTRIBUTE_NAME_ALLOW_SESSION_DELETE);
        ClassMap theClassMap = new ClassMap(className, new TableMap(tableName), idFactoryClassName, permissionName, tableBaseClassName, tableInterfacesNames, disableLocking == null ? false : Boolean.valueOf(disableLocking), preLocking == null ? false : Boolean.valueOf(preLocking), enableCaching == null ? false : Boolean.valueOf(enableCaching), cloneCacheObjects == null || cloneCacheObjects.length() < 1 ? true : Boolean.valueOf(cloneCacheObjects), allowRemoteSaveObject == null || allowRemoteSaveObject.length() < 1 ? false : Boolean.valueOf(allowRemoteSaveObject), allowRemoteDeleteObject == null || allowRemoteDeleteObject.length() < 1 ? false : Boolean.valueOf(allowRemoteDeleteObject), allowSessionDelete == null || allowSessionDelete.length() < 1 ? true : Boolean.valueOf(allowSessionDelete));
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Creating Class Map with ClassName: " + className, this);
        }
        NodeList attributeMaps = inClassMap.getChildNodes();
        for (int i = 0; i < attributeMaps.getLength(); ++i) {
            Node child = attributeMaps.item(i);
            if (child.getNodeType() != 1) continue;
            if (child.getNodeName().equals(NODE_NAME_INT_ATTRIBUTE_MAP)) {
                this.parseIntAttributeMap((Element)child, theClassMap);
                continue;
            }
            if (child.getNodeName().equals(NODE_NAME_ASSOCIATION_ATTRIBUTE_MAP)) {
                this.parseAssociationAttributeMap((Element)child, theClassMap);
                continue;
            }
            if (child.getNodeName().equals(NODE_NAME_ID_ATTRIBUTE_MAP)) {
                this.parseIDAttributeMap((Element)child, theClassMap);
                continue;
            }
            if (child.getNodeName().equals(NODE_NAME_STRING_ATTRIBUTE_MAP)) {
                this.parseStringAttributeMap((Element)child, theClassMap);
                continue;
            }
            if (child.getNodeName().equals(NODE_NAME_DATE_ATTRIBUTE_MAP)) {
                this.parseDateAttributeMap((Element)child, theClassMap);
                continue;
            }
            if (child.getNodeName().equals(NODE_NAME_BOOLEAN_ATTRIBUTE_MAP)) {
                this.parseBooleanAttributeMap((Element)child, theClassMap);
                continue;
            }
            if (child.getNodeName().equals(NODE_NAME_LONG_ATTRIBUTE_MAP)) {
                this.parseLongAttributeMap((Element)child, theClassMap);
                continue;
            }
            if (child.getNodeName().equals(NODE_NAME_FLOAT_ATTRIBUTE_MAP)) {
                this.parseFloatAttributeMap((Element)child, theClassMap);
                continue;
            }
            if (child.getNodeName().equals(NODE_NAME_DOUBLE_ATTRIBUTE_MAP)) {
                this.parseDoubleAttributeMap((Element)child, theClassMap);
                continue;
            }
            if (!child.getNodeName().equals(NODE_NAME_ENUM_ATTRIBUTE_MAP)) continue;
            this.parseEnumAttributeMap((Element)child, theClassMap);
        }
        this.mPM.addClassMap(theClassMap);
    }

    private void parseIntAttributeMap(Element inElement, ClassMap inClassMap) {
        IntAttributeMap theMap = new IntAttributeMap(inElement, inClassMap);
        inClassMap.addAttributeMap(theMap);
    }

    private void parseAssociationAttributeMap(Element inElement, ClassMap inClassMap) {
        AssociationAttributeMap theMap = new AssociationAttributeMap(inElement, inClassMap, this.mPM);
        inClassMap.addAssociationMap(theMap);
    }

    private void parseIDAttributeMap(Element inElement, ClassMap inClassMap) {
        IDAttributeMap theMap = new IDAttributeMap(inElement, inClassMap, this.mPM);
        inClassMap.addAttributeMap(theMap);
    }

    private void parseStringAttributeMap(Element inElement, ClassMap inClassMap) {
        StringAttributeMap theMap = new StringAttributeMap(inElement, inClassMap);
        inClassMap.addAttributeMap(theMap);
    }

    private void parseDateAttributeMap(Element inElement, ClassMap inClassMap) {
        DateAttributeMap theMap = new DateAttributeMap(inElement, inClassMap);
        inClassMap.addAttributeMap(theMap);
    }

    private void parseLongAttributeMap(Element inElement, ClassMap inClassMap) {
        LongAttributeMap theMap = new LongAttributeMap(inElement, inClassMap);
        inClassMap.addAttributeMap(theMap);
    }

    private void parseFloatAttributeMap(Element inElement, ClassMap inClassMap) {
        FloatAttributeMap theMap = new FloatAttributeMap(inElement, inClassMap);
        inClassMap.addAttributeMap(theMap);
    }

    private void parseDoubleAttributeMap(Element inElement, ClassMap inClassMap) {
        DoubleAttributeMap theMap = new DoubleAttributeMap(inElement, inClassMap);
        inClassMap.addAttributeMap(theMap);
    }

    private void parseBooleanAttributeMap(Element inElement, ClassMap inClassMap) {
        BooleanAttributeMap theMap = new BooleanAttributeMap(inElement, inClassMap);
        inClassMap.addAttributeMap(theMap);
    }

    private void parseEnumAttributeMap(Element inElement, ClassMap inClassMap) {
        EnumAttributeMap theMap = new EnumAttributeMap(inElement, inClassMap);
        inClassMap.addAttributeMap(theMap);
    }

    public static void main(String[] args) {
        block10: {
            try {
                PersistApplication theApp = new PersistApplication(args);
                PersistenceManager thePM = theApp.getPMSubsystem();
                FileInputStream inStream = null;
                try {
                    inStream = new FileInputStream(thePM.getConfigDBMappingFile());
                }
                catch (FileNotFoundException e) {
                    if (Logger.isErrorEnabled("com.raplix.rolloutexpress.persist.map.MapXMLReader")) {
                        Logger.error("Could not open mapping file: " + thePM.getConfigDBMappingFile(), "com.raplix.rolloutexpress.persist.map.MapXMLReader");
                    }
                    throw e;
                }
                File outputFile = new File(thePM.getConfigDBSqlGenOutputFile());
                if (!outputFile.exists()) {
                    try {
                        outputFile.createNewFile();
                    }
                    catch (IOException e) {
                        if (Logger.isErrorEnabled("com.raplix.rolloutexpress.persist.map.MapXMLReader")) {
                            Logger.error("Could not open output sql file: " + thePM.getConfigDBSqlGenOutputFile(), "com.raplix.rolloutexpress.persist.map.MapXMLReader");
                        }
                        throw e;
                    }
                }
                FileWriter outputFileWriter = new FileWriter(outputFile);
                MapXMLReader theReader = new MapXMLReader(thePM, inStream, true);
                theReader.readFromXML();
                String theSQL = thePM.generateSQLCreateSchema(true);
                outputFileWriter.write(theSQL);
                outputFileWriter.close();
                if (Logger.isInfoEnabled("com.raplix.rolloutexpress.persist.map.MapXMLReader")) {
                    Logger.info("Finishing Writing to SQL file: " + thePM.getConfigDBSqlGenOutputFile(), "com.raplix.rolloutexpress.persist.map.MapXMLReader");
                }
            }
            catch (Exception e) {
                if (!Logger.isErrorEnabled("com.raplix.rolloutexpress.persist.map.MapXMLReader")) break block10;
                Logger.error("Error Runing SQL Gen", e, "com.raplix.rolloutexpress.persist.map.MapXMLReader");
            }
        }
    }

    private static class PersistApplication
    extends Application {
        protected PersistenceManager mPM = new PersistenceManager(this, false, null, false);

        public PersistApplication(String[] inCommandLineArgs) throws ConfigurationException {
            super(inCommandLineArgs);
        }

        public PersistenceManager getPMSubsystem() {
            return this.mPM;
        }

        public NetSubsystem getNetSubsystem() {
            return null;
        }

        protected String getUsageString() {
            return "Usage";
        }

        protected String getVersionString() {
            return "$Revision: 1.19 $";
        }

        protected void shutdown() {
            block2: {
                try {
                    this.mPM.shutdown();
                }
                catch (Exception e) {
                    if (!Logger.isErrorEnabled(this)) break block2;
                    Logger.error("Error on shutdown", e, this);
                }
            }
        }

        protected void buildConfigurationFilesForSubsystems(Hashtable inTable) throws ConfigurationException {
            Subsystem.addConfigurationForSubsystem(inTable, class$com$raplix$rolloutexpress$persist$PersistenceManager == null ? (class$com$raplix$rolloutexpress$persist$PersistenceManager = MapXMLReader.class$("com.raplix.rolloutexpress.persist.PersistenceManager")) : class$com$raplix$rolloutexpress$persist$PersistenceManager);
        }

        protected void exitProcess(int inExitCode) {
        }
    }
}

