/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.map;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.persist.Messages;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.ObjectIDFactory;
import com.raplix.rolloutexpress.persist.PersistPermission;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.PersistentBeanManagerImpl;
import com.raplix.rolloutexpress.persist.SaveResult;
import com.raplix.rolloutexpress.persist.VersionedPersistentBean;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.cache.CacheKey;
import com.raplix.rolloutexpress.persist.cache.ObjectCache;
import com.raplix.rolloutexpress.persist.cache.SingleObjectByIDCache;
import com.raplix.rolloutexpress.persist.cache.SingleObjectCache;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.map.TableMap;
import com.raplix.rolloutexpress.persist.map.attribute.AssociationAttributeMap;
import com.raplix.rolloutexpress.persist.map.attribute.AttributeMap;
import com.raplix.rolloutexpress.persist.map.attribute.DateAttributeMap;
import com.raplix.rolloutexpress.persist.map.attribute.EnumAttributeMap;
import com.raplix.rolloutexpress.persist.map.attribute.IDAttributeMap;
import com.raplix.rolloutexpress.persist.map.attribute.IntAttributeMap;
import com.raplix.rolloutexpress.persist.map.exception.ClassMapException;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.persist.query.builder.TableClassGenerator;
import com.raplix.rolloutexpress.persist.query.builder.TableDependency;
import com.raplix.rolloutexpress.persist.sql.Database;
import com.raplix.rolloutexpress.persist.sql.SQLStatement;
import com.raplix.rolloutexpress.systemmodel.userdb.PersistentUserData;
import com.raplix.util.logger.Logger;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public final class ClassMap
implements Messages {
    private HashMap mAttributeMaps = new HashMap();
    private HashMap mAssociationMaps = new HashMap();
    private TableMap mTableMap;
    private String mMappedClassName;
    private String mIDFactoryClassName;
    private Class mMappedClassClass;
    private ObjectIDFactory mIDFactory = null;
    private String mPermissionName = null;
    private PersistPermission mReadPermission;
    private PersistPermission mWritePermission;
    private boolean mDisableLocking = false;
    private boolean mPreLocking = false;
    private ObjectCache mObjectCache = null;
    private boolean mCloneCacheObjects = true;
    private boolean mAllowRemoteSaveObject = false;
    private boolean mAllowRemoteDeleteObject = false;
    private boolean mAllowSessionDelete = true;
    private PersistentBeanManagerImpl mBeanManager;
    private Constructor mDefaultConstructor = null;
    private Table mTable;
    private String mTableBaseClass;
    private String mTableClassInterfaces;
    private Vector mDependencies = new Vector();
    HashMap mSingleObjectCacheMap = new HashMap();

    public ClassMap(String inClassName, TableMap inTableMap, String inIDFactoryClassName, String inPermissionName, String inTableBaseClass, String inTableClassInterfaces, boolean inDisableLocking, boolean inPreLocking, boolean inCacheObjects, boolean inCloneCacheObjects, boolean inAllowRemoteSaveObject, boolean inAllowRemoteDeleteObject, boolean inAllowSessionDelete) {
        this.mMappedClassName = inClassName;
        this.mTableMap = inTableMap;
        this.mTableBaseClass = inTableBaseClass;
        this.mTableClassInterfaces = inTableClassInterfaces;
        this.mDisableLocking = inDisableLocking;
        this.mPreLocking = inPreLocking;
        this.mCloneCacheObjects = inCloneCacheObjects;
        this.mIDFactoryClassName = inIDFactoryClassName != null && !inIDFactoryClassName.equals("") ? inIDFactoryClassName : this.mMappedClassName + "ID$IDFactory";
        this.setPermissionName(inPermissionName);
        if (inCacheObjects) {
            this.mObjectCache = new ObjectCache(this);
            if (Logger.isInfoEnabled(this)) {
                Logger.info("Enabling caching for " + inClassName, this);
            }
        }
        this.mAllowRemoteSaveObject = inAllowRemoteSaveObject;
        this.mAllowRemoteDeleteObject = inAllowRemoteDeleteObject;
        this.mAllowSessionDelete = inAllowSessionDelete;
    }

    public void init(PersistentBeanManagerImpl inBeanManager) throws ClassMapException {
        AttributeMap attribMap;
        this.mBeanManager = inBeanManager;
        try {
            this.mMappedClassClass = Class.forName(this.mMappedClassName);
        }
        catch (ClassNotFoundException e) {
            throw new ClassMapException(new ROXMessage("pm.cm.NO_CLASS_FOUND", new String[]{this.mMappedClassName}));
        }
        if (this.mDisableLocking && this.mObjectCache != null) {
            throw new ClassMapException(new ROXMessage("pm.cm.CANNOT_CACHE_WITHOUT_LOCKING"));
        }
        try {
            this.mDefaultConstructor = this.mMappedClassClass.getDeclaredConstructor(new Class[0]);
            this.mDefaultConstructor.setAccessible(true);
        }
        catch (NoSuchMethodException nsme) {
            throw new ClassMapException(new ROXMessage("pm.cm.NO_DEF_CONSTRUCTOR", new Object[]{this.mMappedClassName}), (Throwable)nsme);
        }
        if (VersionedPersistentBean.class.isAssignableFrom(this.mMappedClassClass)) {
            attribMap = new IDAttributeMap(this, "RootID", "ROOT_ID", false, false, false, false, this);
            this.addAttributeMap(attribMap);
            ClassMap userClassMap = PersistenceManager.getInstance().getClassMap(PersistentUserData.class.getName());
            if (userClassMap == null) {
                throw new ClassMapException(new ROXMessage("pm.cm.NO_CLASSMAP_FOR_CLASS", new String[]{PersistentUserData.class.getName()}));
            }
            attribMap = new IDAttributeMap(this, "UserID", "USER_ID", false, true, false, false, userClassMap);
            this.addAttributeMap(attribMap);
            attribMap = new IntAttributeMap(this, "Version", "VERSION", false, false, false, false);
            this.addAttributeMap(attribMap);
            attribMap = new DateAttributeMap(this, "TimeStamp", "C_TIMESTAMP", false, false, false, false);
            this.addAttributeMap(attribMap);
        }
        attribMap = new IntAttributeMap(this, "UpdateCount", "C_UPDATE_COUNT", false, false, false, false);
        this.addAttributeMap(attribMap);
        attribMap = new EnumAttributeMap(this, "Visibility", "C_VISIBILITY", false, false, false, false, Visibility.class);
        this.addAttributeMap(attribMap);
        Iterator theIT = this.mAttributeMaps.values().iterator();
        while (theIT.hasNext()) {
            AttributeMap currMap = (AttributeMap)theIT.next();
            currMap.init();
        }
        Class<?> theIDFactoryClass = null;
        try {
            theIDFactoryClass = Class.forName(this.mIDFactoryClassName);
        }
        catch (Exception e) {
            throw new ClassMapException(new ROXMessage("pm.cm.CANNOT_CONSTRUCT_ID_FACTORY", new String[]{this.mIDFactoryClassName}), (Throwable)e);
        }
        try {
            Constructor<?> constructor = theIDFactoryClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            this.mIDFactory = (ObjectIDFactory)constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new ClassMapException(new ROXMessage("pm.cm.CANNOT_CONSTRUCT_ID_INSTANCE", new String[]{this.mIDFactoryClassName}), (Throwable)e);
        }
        if (PersistenceManager.isInitTables()) {
            try {
                Class<?> tableClass = Class.forName(TableClassGenerator.getTableClassName(this.getMappedClass()));
                Field defaultInstance = tableClass.getField("DEFAULT");
                this.mTable = (Table)defaultInstance.get(null);
            }
            catch (Exception e) {
                throw new ClassMapException(new ROXMessage("pm.cm.ERR_INIT_TABLE_INSTANCE", new Object[]{this.getMappedClass().getName()}), (Throwable)e);
            }
        }
        if (this.mObjectCache != null) {
            this.addSingleObjectCache(new SingleObjectByIDCache(this.mObjectCache));
            this.mIDFactory.registerCaches(this, this.mObjectCache);
        }
    }

    public ObjectIDFactory getIDFactory() {
        return this.mIDFactory;
    }

    public HashMap getAttributeMaps() {
        return this.mAttributeMaps;
    }

    public HashMap getAssociationMaps() {
        return this.mAssociationMaps;
    }

    public Database getDatabase() {
        return PersistenceManager.getInstance().getDefaultDatabase();
    }

    public String getClassName() {
        return this.mMappedClassName;
    }

    public Class getMappedClass() {
        return this.mMappedClassClass;
    }

    public TableMap getTableMap() {
        return this.mTableMap;
    }

    public void addAttributeMap(AttributeMap inAttributeMap) {
        this.mAttributeMaps.put(inAttributeMap.getAttributeName(), inAttributeMap);
    }

    public void addAssociationMap(AssociationAttributeMap inAssociationMap) {
        this.mAssociationMaps.put(inAssociationMap.getAttributeName(), inAssociationMap);
        this.mAttributeMaps.put(inAssociationMap.getAttributeName(), inAssociationMap);
    }

    public AttributeMap getAttributeMap(String inAttributeName) {
        return (AttributeMap)this.mAttributeMaps.get(inAttributeName);
    }

    public SQLStatement getTableAndColumnSelectionClause() throws ClassMapException {
        SQLStatement stmt = new SQLStatement();
        stmt.addSQLClause(this.getDatabase().getClauseStringSelect() + " ");
        this.addSQLColumnLabelsClause(stmt, null, false);
        stmt.addSQLClause(" " + this.getDatabase().getClauseStringFrom() + " ");
        this.addSQLTableClause(stmt);
        stmt.addSQLClause(" ");
        return stmt;
    }

    public SQLStatement getSelectSQLFor(PersistentBean inObject) throws ClassMapException {
        SQLStatement stmt = this.getTableAndColumnSelectionClause();
        this.addSQLPrimaryKeyWhereClause(stmt, this.getBeanManager().getObjectID(inObject));
        return stmt;
    }

    public SQLStatement getUpdateSQLFor(PersistentBean inObject) throws ClassMapException {
        SQLStatement stmt = new SQLStatement();
        stmt.addSQLClause(this.getDatabase().getClauseStringUpdate() + " ");
        this.addSQLTableClause(stmt);
        stmt.addSQLClause(" " + this.getDatabase().getClauseStringSet() + " ");
        this.addSQLColumnLabelsClause(stmt, inObject, false);
        stmt.addSQLClause(" ");
        this.addSQLPrimaryKeyWhereClause(stmt, this.getBeanManager().getObjectID(inObject));
        if (!this.mDisableLocking) {
            this.addUpdateCountCheckClause(stmt, inObject);
        }
        return stmt;
    }

    public SQLStatement getInsertSQLFor(PersistentBean inObject) throws ClassMapException {
        SQLStatement stmt = new SQLStatement();
        this.getBeanManager().setUpdateCount(inObject, 1);
        stmt.addSQLClause(this.getDatabase().getClauseStringInsert() + " ");
        this.addSQLTableClause(stmt);
        StringBuffer columnsClause = new StringBuffer();
        StringBuffer valuesClause = new StringBuffer();
        columnsClause.append(" ( ");
        valuesClause.append(" ( ");
        boolean isFirst = true;
        Iterator theIT = this.mAttributeMaps.values().iterator();
        while (theIT.hasNext()) {
            AttributeMap currMap = (AttributeMap)theIT.next();
            if (currMap.isNotAuto()) continue;
            columnsClause.append(isFirst ? "" : ",");
            columnsClause.append(currMap.getColumnName());
            String value = currMap.getAsSQLString(inObject);
            valuesClause.append(isFirst ? "" : ",");
            valuesClause.append(value);
            isFirst = false;
        }
        columnsClause.append(isFirst ? "" : ",");
        StringBuffer stringBuffer = new StringBuffer();
        this.getBeanManager().getObjectID(inObject);
        columnsClause.append(stringBuffer.append(ObjectID.generateSQLColumnNames()).append(" ) ").toString());
        valuesClause.append(isFirst ? "" : ",");
        valuesClause.append(this.getBeanManager().getObjectID(inObject).generateSQLInsertValues() + " ) ");
        stmt.addSQLClause(columnsClause.toString());
        stmt.addSQLClause(" " + this.getDatabase().getClauseStringValues() + " ");
        stmt.addSQLClause(valuesClause.toString());
        return stmt;
    }

    public void addSQLColumnLabelsClause(SQLStatement ioStatement, PersistentBean inObject, boolean inIsFullyQualifiedNames) throws ClassMapException {
        boolean isFirst = true;
        inIsFullyQualifiedNames = false;
        if (inObject == null) {
            ioStatement.addSQLClause(inIsFullyQualifiedNames ? this.getTableMap().getTableName() + "." + ObjectID.generateSQLColumnNames() : ObjectID.generateSQLColumnNames());
            isFirst = false;
        }
        Iterator theIT = this.mAttributeMaps.values().iterator();
        while (theIT.hasNext()) {
            AttributeMap currMap = (AttributeMap)theIT.next();
            if (currMap.isNotAuto()) continue;
            ioStatement.addSQLClause(isFirst ? "" : ",");
            if (inObject == null && currMap instanceof DateAttributeMap && !currMap.isArray()) {
                String colSpec = currMap.getColumnName();
                ioStatement.addSQLClause(this.getDatabase().getTimeStampRetrievalString(colSpec)).addSQLClause(" ");
                ioStatement.addSQLClause(this.getDatabase().getClauseStringAS()).addSQLClause(" ");
                ioStatement.addSQLClause(colSpec);
            } else {
                ioStatement.addSQLClause(inIsFullyQualifiedNames ? currMap.getFullyQualifiedColumnName() : currMap.getColumnName());
            }
            if (inObject != null) {
                if (currMap.getAttributeName().equals("UpdateCount")) {
                    ioStatement.addSQLClause("= " + this.getDatabase().getUpdateCountSetString("C_UPDATE_COUNT"));
                } else {
                    String value = currMap.getAsSQLString(inObject);
                    ioStatement.addSQLClause("=" + value);
                }
            }
            isFirst = false;
        }
    }

    public void addSQLTableClause(SQLStatement ioStatement) {
        ioStatement.addSQLClause(this.mTableMap.getTableName());
    }

    public void addSQLPrimaryKeyWhereClause(SQLStatement ioStatement, ObjectID inObjectID) throws ClassMapException {
        ioStatement.addSQLClause(this.getDatabase().getClauseStringWhere() + " ");
        ioStatement.addSQLClause(inObjectID.generateSQLWhereClause());
    }

    public PersistentBean retrieveObject(ResultSet inRS, Table inTable) throws SQLException, ClassMapException {
        PersistentBean ioObject = null;
        ioObject = this.newInstance();
        Enumeration columns = inTable.getColumns();
        ColumnNode cNode = null;
        AttributeMap aMap = null;
        while (columns.hasMoreElements()) {
            cNode = (ColumnNode)columns.nextElement();
            aMap = cNode.getAttributeMap();
            if (aMap != null) {
                aMap.setValueFromResultSet(ioObject, inRS, cNode.getSQLColumnName());
                continue;
            }
            String theID = inRS.getString(cNode.getSQLColumnName());
            this.getBeanManager().setObjectID(ioObject, this.getIDFactory().generateObjectID(theID));
        }
        this.getBeanManager().setPersistent(ioObject, true);
        return ioObject;
    }

    public PersistentBean retrieveObject(ResultSet inRS, Table inTable, int inFlushCount) throws SQLException, ClassMapException {
        PersistentBean result = this.retrieveObject(inRS, inTable);
        this.updateCache(result, inFlushCount);
        return result;
    }

    public void retrieveObject(PersistentBean ioObject, ResultSet inRS) throws SQLException, ClassMapException {
        String theID = inRS.getString(ObjectID.generateSQLColumnNames());
        this.getBeanManager().setObjectID(ioObject, this.getIDFactory().generateObjectID(theID));
        Iterator theIT = this.mAttributeMaps.values().iterator();
        while (theIT.hasNext()) {
            AttributeMap currMap = (AttributeMap)theIT.next();
            if (currMap.isNotAuto()) continue;
            currMap.setValueFromResultSet(ioObject, inRS, currMap.getColumnName());
        }
        this.getBeanManager().setPersistent(ioObject, true);
    }

    public PersistentBean retrieveObject(ResultSet inRS) throws SQLException, ClassMapException {
        PersistentBean po = this.newInstance();
        this.retrieveObject(po, inRS);
        return po;
    }

    public PersistentBean clone(PersistentBean inObject) throws ClassMapException {
        PersistentBean po = this.newInstance();
        this.copyInto(inObject, po);
        return po;
    }

    public PersistentBean newInstance() throws ClassMapException {
        try {
            return (PersistentBean)this.mDefaultConstructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException iae) {
            throw new ClassMapException(new ROXMessage("pm.query.CANT_INSTANCIATE_OBJECT"), (Throwable)iae, 1);
        }
        catch (InstantiationException ie) {
            throw new ClassMapException(new ROXMessage("pm.query.CANT_INSTANCIATE_OBJECT"), (Throwable)ie, 1);
        }
        catch (InvocationTargetException ite) {
            throw new ClassMapException(new ROXMessage("pm.query.CANT_INSTANCIATE_OBJECT"), (Throwable)ite, 1);
        }
    }

    public void copyInto(PersistentBean fromObject, PersistentBean toObject) throws ClassMapException {
        this.getBeanManager().setObjectID(toObject, this.getBeanManager().getObjectID(fromObject));
        this.getBeanManager().setPersistent(toObject, this.getBeanManager().isPersistent(fromObject));
        Iterator iterator = this.mAttributeMaps.values().iterator();
        while (iterator.hasNext()) {
            ((AttributeMap)iterator.next()).copyValue(fromObject, toObject);
        }
    }

    public SQLStatement getDeleteSQLFor(ObjectID inObjectID) throws ClassMapException {
        SQLStatement stmt = new SQLStatement();
        stmt.addSQLClause(this.getDatabase().getClauseStringDelete() + " ");
        stmt.addSQLClause(this.getDatabase().getClauseStringFrom() + " ");
        this.addSQLTableClause(stmt);
        stmt.addSQLClause(" ");
        this.addSQLPrimaryKeyWhereClause(stmt, inObjectID);
        return stmt;
    }

    public String generateTableDropSQL() {
        return this.getDatabase().getDropTableClause() + " " + this.mTableMap.getTableName() + ";\n\n";
    }

    public String generateTableSQL(boolean inCreateDropClause) throws ClassMapException {
        StringBuffer theBuff = new StringBuffer();
        theBuff.append("-- SQL Table Generation from Classmap for Class: " + this.mMappedClassName + "\n\n");
        if (inCreateDropClause) {
            theBuff.append(this.generateTableDropSQL());
        }
        theBuff.append(this.getDatabase().getCreateTableClause());
        theBuff.append(" " + this.mTableMap.getTableName() + " (" + "\n");
        theBuff.append(ObjectID.generateSQLColumnNames() + "\t" + ObjectID.generateSQLColumnTypeDefinition(this.getDatabase()) + ",\n");
        Iterator theIT = this.mAttributeMaps.values().iterator();
        while (theIT.hasNext()) {
            AttributeMap currMap = (AttributeMap)theIT.next();
            currMap.generateSQLColumnDefinition(this.getDatabase(), theBuff);
            theBuff.append((theIT.hasNext() ? "," : "") + "\n");
        }
        theBuff.append(" );");
        return theBuff.toString();
    }

    public String toString() {
        return "ClassMap for " + this.mMappedClassName;
    }

    public String getPermissionName() {
        return this.mPermissionName;
    }

    private void setPermissionName(String permissionName) {
        if (permissionName != null && permissionName.length() == 0) {
            permissionName = null;
        }
        this.mPermissionName = permissionName;
        if (permissionName == null) {
            this.mReadPermission = null;
            this.mWritePermission = null;
        } else {
            this.mReadPermission = new PersistPermission(permissionName, "read");
            this.mWritePermission = new PersistPermission(permissionName, "write");
        }
    }

    public void checkReadPermission() {
        this.checkPermission(this.mReadPermission);
    }

    public void checkWritePermission() {
        this.checkPermission(this.mWritePermission);
    }

    public void checkDeletePermission() {
        this.checkPermission(this.mWritePermission);
    }

    private void checkPermission(PersistPermission perm) {
        if (perm != null) {
            AccessController.checkPermission(perm);
        }
    }

    public void addUpdateCountCheckClause(SQLStatement inStatement, PersistentBean inObject) {
        inStatement.addSQLClause(" ").addSQLClause(this.getDatabase().getClauseStringAnd());
        inStatement.addSQLClause(" ").addSQLClause("C_UPDATE_COUNT");
        inStatement.addSQLClause(" ").addSQLClause("=");
        inStatement.addSQLClause(" ").addSQLClause(IntAttributeMap.convertToString(this.getBeanManager().getUpdateCount(inObject)));
    }

    public boolean isDisableLocking() {
        return this.mDisableLocking;
    }

    public boolean isPreLocking() {
        return this.mPreLocking && !this.mDisableLocking;
    }

    public boolean isRemoteSaveAllowed() {
        return this.mAllowRemoteSaveObject;
    }

    public boolean isRemoteDeleteAllowed() {
        return this.mAllowRemoteDeleteObject;
    }

    public boolean isDeleteSessionAllowed() {
        return this.mAllowSessionDelete;
    }

    public void updateCache(PersistentBean inObject, int inFlushCount) throws ClassMapException {
        if (this.mObjectCache != null) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Updating cache:obj:" + inObject + ":fc:" + inFlushCount, this);
            }
            this.mObjectCache.updateObject(inObject, inFlushCount);
        }
    }

    public void updateCache(PersistentBean[] inObjects, int inFlushCount) throws ClassMapException {
        if (this.mObjectCache != null) {
            this.mObjectCache.updateObject(inObjects, inFlushCount);
        }
    }

    public int getCacheFlushCount() {
        return this.mObjectCache != null ? this.mObjectCache.getFlushCount() : -1;
    }

    public void removeCacheObject(ObjectID inObjectID) {
        if (this.mObjectCache != null) {
            this.mObjectCache.removeObject(inObjectID);
        }
    }

    public void invalidateCache() {
        if (this.mObjectCache != null) {
            this.mObjectCache.invalidateEntireCache();
        }
    }

    public boolean retrieveCachedObject(PersistentBean inObject) throws ClassMapException, PersistenceManagerException {
        PersistentBean obj;
        if (this.mObjectCache != null && (obj = this.mObjectCache.findObject(this.getBeanManager().getObjectID(inObject))) != null) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Retrieved cached object:" + obj, this);
            }
            this.copyInto(obj, inObject);
            this.loadAssociations(inObject);
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Copied cached object into :" + inObject, this);
            }
            return true;
        }
        return false;
    }

    public PersistentBean retrieveCachedObject(ObjectID inObjectID) throws ClassMapException, PersistenceManagerException {
        PersistentBean obj;
        if (this.mObjectCache != null && (obj = this.mObjectCache.findObject(inObjectID)) != null) {
            return this.cloneForCache(obj);
        }
        return null;
    }

    public ObjectCache getCache() {
        return this.mObjectCache;
    }

    public void loadAssociations(PersistentBean obj) throws ClassMapException, PersistenceManagerException {
        Iterator associations = this.getAssociationMaps().values().iterator();
        while (associations.hasNext()) {
            Object pObj;
            AssociationAttributeMap aMap = (AssociationAttributeMap)associations.next();
            if (aMap.isArray()) {
                pObj = (PersistentBean[])aMap.getValue(obj);
                if (pObj == null) continue;
                for (int i = 0; i < ((PersistentBean[])pObj).length; ++i) {
                    if (pObj[i] == null) continue;
                    this.getBeanManager().retrieve(pObj[i]);
                }
                continue;
            }
            pObj = (PersistentBean)aMap.getValue(obj);
            if (pObj == null) continue;
            this.getBeanManager().retrieve((PersistentBean)pObj);
        }
    }

    public PersistentBeanManagerImpl getBeanManager() {
        return this.mBeanManager;
    }

    public void addAssociationToSaveResult(PersistentBean inBean, SaveResult inResult) throws PersistenceManagerException {
        HashMap maps = this.getAssociationMaps();
        if (!maps.isEmpty()) {
            Iterator iterator = maps.values().iterator();
            while (iterator.hasNext()) {
                AssociationAttributeMap aMap = (AssociationAttributeMap)iterator.next();
                if (aMap.isArray()) {
                    PersistentBean[] beans = (PersistentBean[])aMap.getValue(inBean);
                    if (beans == null) continue;
                    SaveResult[] results = new SaveResult[beans.length];
                    for (int i = 0; i < beans.length; ++i) {
                        results[i] = beans[i] != null ? this.getBeanManager().createSaveResult(beans[i]) : null;
                    }
                    this.getBeanManager().setAssociation(inResult, aMap.getAttributeName(), results);
                    continue;
                }
                PersistentBean aBean = (PersistentBean)aMap.getValue(inBean);
                if (aBean == null) continue;
                this.getBeanManager().setAssociation(inResult, aMap.getAttributeName(), this.getBeanManager().createSaveResult(aBean));
            }
        }
    }

    public void setAssociationFromSaveResult(PersistentBean inBean, SaveResult inResult) throws PersistenceManagerException {
        HashMap maps = this.getAssociationMaps();
        if (!maps.isEmpty()) {
            Iterator iterator = maps.values().iterator();
            while (iterator.hasNext()) {
                AssociationAttributeMap aMap = (AssociationAttributeMap)iterator.next();
                if (aMap.isArray()) {
                    SaveResult[] results = this.getBeanManager().getArrayAssociation(inResult, aMap.getAttributeName());
                    if (results == null) continue;
                    PersistentBean[] beans = (PersistentBean[])aMap.getValue(inBean);
                    for (int i = 0; i < results.length; ++i) {
                        if (results[i] == null) continue;
                        this.getBeanManager().setSaveResult(beans[i], results[i]);
                    }
                    continue;
                }
                SaveResult aResult = this.getBeanManager().getAssociation(inResult, aMap.getAttributeName());
                if (aResult == null) continue;
                PersistentBean aBean = (PersistentBean)aMap.getValue(inBean);
                this.getBeanManager().setSaveResult(aBean, aResult);
            }
        }
    }

    public Table getTable() {
        return this.mTable;
    }

    public PersistentBean cloneForCache(PersistentBean inBean) throws ClassMapException {
        return this.mCloneCacheObjects ? this.clone(inBean) : inBean;
    }

    public String getTableBaseClassName() {
        return this.mTableBaseClass;
    }

    public String getTableClassInterfaces() {
        return this.mTableClassInterfaces;
    }

    public SingleObjectCache getSingleObjectCache(String cacheName) {
        return (SingleObjectCache)this.mSingleObjectCacheMap.get(cacheName);
    }

    public void addSingleObjectCache(SingleObjectCache cache) {
        this.mSingleObjectCacheMap.put(cache.getName(), cache);
    }

    public PersistentBean retrieveBeanFromCache(String cacheName, CacheKey key) throws ClassMapException {
        PersistentBean bean;
        SingleObjectCache cache = this.getSingleObjectCache(cacheName);
        if (cache != null && (bean = cache.findObject(key)) != null) {
            this.checkReadPermission();
            return this.cloneForCache(bean);
        }
        return null;
    }

    public void registerDependency(TableDependency dep) {
        this.mDependencies.add(dep);
    }

    public Enumeration getDependencies() {
        return this.mDependencies.elements();
    }
}

