/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.cache;

import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.cache.GlobalObjectCache;
import com.raplix.rolloutexpress.persist.cache.ObjectMap;
import com.raplix.rolloutexpress.persist.cache.PlainObjectMap;
import com.raplix.rolloutexpress.persist.map.ClassMap;
import com.raplix.rolloutexpress.persist.map.exception.ClassMapException;
import com.raplix.util.logger.Logger;
import java.util.HashSet;
import java.util.Iterator;

public final class TransactionObjectCache {
    private HashSet dirtyObjectIDs = new HashSet();
    private volatile boolean mFlushed = false;
    private ObjectMap objectMap;
    private ClassMap mClassMap;
    private volatile int mHits = 0;
    private volatile int mMiss = 0;

    public TransactionObjectCache(ClassMap inClassMap) {
        this.mClassMap = inClassMap;
        this.objectMap = new PlainObjectMap();
    }

    synchronized void init() {
        this.objectMap.clear();
        this.mFlushed = false;
        this.dirtyObjectIDs.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PersistentBean findObject(ObjectID inObjectID) {
        PersistentBeanContainer poc;
        TransactionObjectCache transactionObjectCache = this;
        synchronized (transactionObjectCache) {
            poc = (PersistentBeanContainer)this.objectMap.find(inObjectID);
            if (poc == null) {
                ++this.mMiss;
            } else {
                ++this.mHits;
            }
        }
        return poc == null ? null : poc.pObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateObject(PersistentBean inObject, int inFlushCount) throws ClassMapException {
        if (inObject == null) {
            return;
        }
        TransactionObjectCache transactionObjectCache = this;
        synchronized (transactionObjectCache) {
            PersistentBeanContainer poc = (PersistentBeanContainer)this.objectMap.find(this.mClassMap.getBeanManager().getObjectID(inObject));
            if (poc == null) {
                this.objectMap.update(this.createContainer(this.mClassMap.cloneForCache(inObject), inFlushCount), this.mClassMap.getBeanManager().getObjectID(inObject));
            } else if (poc.flushCount != inFlushCount && this.mClassMap.getBeanManager().getUpdateCount(poc.pObject) < this.mClassMap.getBeanManager().getUpdateCount(inObject)) {
                poc.pObject = inObject;
                poc.flushCount = inFlushCount;
            }
        }
    }

    synchronized void removeObject(ObjectID inObjectID) {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("removeObjTxn:" + inObjectID, this);
        }
        if (!this.mFlushed) {
            this.dirtyObjectIDs.add(inObjectID);
        }
        this.objectMap.remove(inObjectID);
    }

    synchronized void invalidateEntireCache() {
        this.mFlushed = true;
        this.dirtyObjectIDs.clear();
        this.objectMap.clear();
    }

    public boolean isDirty(ObjectID inObjectID) {
        return this.mFlushed || this.dirtyObjectIDs.contains(inObjectID);
    }

    public boolean isFlushed() {
        return this.mFlushed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void reconcileWithGlobalCache(GlobalObjectCache inCache) throws ClassMapException {
        GlobalObjectCache globalObjectCache = inCache;
        synchronized (globalObjectCache) {
            int cacheFlushed = inCache.getFlushCount();
            if (this.mFlushed) {
                inCache.invalidateEntireCache();
            } else {
                Iterator dirtyObjects = this.dirtyObjectIDs.iterator();
                while (dirtyObjects.hasNext()) {
                    inCache.removeObject((ObjectID)dirtyObjects.next());
                }
            }
            cacheFlushed = inCache.getFlushCount() - cacheFlushed;
            Iterator iter = this.objectMap.values();
            while (iter.hasNext()) {
                PersistentBeanContainer poc = (PersistentBeanContainer)iter.next();
                if (poc == null) continue;
                inCache.updateObject(poc.pObject, poc.flushCount + cacheFlushed, false);
            }
        }
    }

    public String toString() {
        return "TransactionCache:" + this.mClassMap.getClassName() + ":Hits:" + this.mHits + ":Miss:" + this.mMiss + ":Flushed:" + this.mFlushed;
    }

    private PersistentBeanContainer createContainer(PersistentBean inObject, int inFlushCount) {
        return new PersistentBeanContainer(inObject, inFlushCount);
    }

    public final double getHitRate() {
        int total = this.mHits + this.mMiss;
        return total == 0 ? 0.0 : (double)this.mHits / (double)total;
    }

    public int getHits() {
        return this.mHits;
    }

    public int getMiss() {
        return this.mMiss;
    }

    private static class PersistentBeanContainer {
        PersistentBean pObject;
        int flushCount;

        PersistentBeanContainer(PersistentBean inObject, int inFlushCount) {
            this.pObject = inObject;
            this.flushCount = inFlushCount;
        }
    }
}

