/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.cache;

import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.cache.CacheKey;
import com.raplix.rolloutexpress.persist.cache.CustomSingleObjectCache;
import com.raplix.rolloutexpress.persist.cache.ObjectCache;
import com.raplix.rolloutexpress.persist.map.attribute.AttributeMap;
import com.raplix.rolloutexpress.persist.map.exception.ClassMapException;
import com.raplix.rolloutexpress.persist.query.builder.IntColumn;
import com.raplix.rolloutexpress.persist.query.builder.StringColumn;

public class SingleVersionedObjectByNameCache
extends CustomSingleObjectCache {
    private AttributeMap mNameMap;
    private AttributeMap mVersionMap;
    public static final String NAME = "byNameAndVersion";

    public SingleVersionedObjectByNameCache(ObjectCache objectCache, StringColumn nameColumn, IntColumn versionColumn) {
        this(objectCache, nameColumn.getAttributeMap(), versionColumn.getAttributeMap());
    }

    public SingleVersionedObjectByNameCache(ObjectCache objectCache, AttributeMap nameMap, AttributeMap versionMap) {
        super(objectCache);
        this.mNameMap = nameMap;
        this.mVersionMap = versionMap;
    }

    public String getName() {
        return NAME;
    }

    protected CacheKey createKey(PersistentBean inObject) throws ClassMapException {
        String name = (String)this.mNameMap.getValue(inObject);
        int rawVersion = (Integer)this.mVersionMap.getValue(inObject);
        String version = new VersionNumber(rawVersion).getAsString();
        return SingleVersionedObjectByNameCache.createKey(name, version);
    }

    public static CacheKey createKey(String name, String version) {
        StringBuffer buf = new StringBuffer();
        buf.append(version);
        buf.append(":");
        buf.append(name);
        return new CacheKey.StringKey(buf.toString());
    }
}

