/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.cache;

import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.cache.CacheKey;
import com.raplix.rolloutexpress.persist.cache.CustomSingleObjectCache;
import com.raplix.rolloutexpress.persist.cache.ObjectCache;
import com.raplix.rolloutexpress.persist.map.attribute.AttributeMap;
import com.raplix.rolloutexpress.persist.map.exception.ClassMapException;
import com.raplix.rolloutexpress.persist.query.builder.IDColumn;
import com.raplix.rolloutexpress.persist.query.builder.IntColumn;
import com.raplix.rolloutexpress.persist.query.builder.StringColumn;

public class SingleVersionedObjectByFullNameCache
extends CustomSingleObjectCache {
    private AttributeMap mPathMap;
    private AttributeMap mNameMap;
    private AttributeMap mVersionMap;
    public static final String NAME = "byFullNameAndVersion";

    public SingleVersionedObjectByFullNameCache(ObjectCache objectCache, IDColumn pathIDColumn, StringColumn nameColumn, IntColumn versionColumn) {
        this(objectCache, pathIDColumn.getAttributeMap(), nameColumn.getAttributeMap(), versionColumn.getAttributeMap());
    }

    public SingleVersionedObjectByFullNameCache(ObjectCache objectCache, AttributeMap pathMap, AttributeMap nameMap, AttributeMap versionMap) {
        super(objectCache);
        this.mPathMap = pathMap;
        this.mNameMap = nameMap;
        this.mVersionMap = versionMap;
    }

    public String getName() {
        return NAME;
    }

    protected CacheKey createKey(PersistentBean inObject) throws ClassMapException {
        ObjectID pathID = (ObjectID)this.mPathMap.getValue(inObject);
        String name = (String)this.mNameMap.getValue(inObject);
        int rawVersion = (Integer)this.mVersionMap.getValue(inObject);
        String version = new VersionNumber(rawVersion).getAsString();
        return SingleVersionedObjectByFullNameCache.createKey(pathID, name, version);
    }

    public static CacheKey createKey(ObjectID inPathID, String name, String version) {
        String pathStr = inPathID == null ? "<null>" : inPathID.toString();
        return SingleVersionedObjectByFullNameCache.createKey(pathStr, name, version);
    }

    private static CacheKey createKey(String path, String name, String version) {
        StringBuffer buf = new StringBuffer();
        buf.append(version);
        buf.append(":");
        buf.append(path);
        buf.append(name);
        return new CacheKey.StringKey(buf.toString());
    }
}

