/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.cache;

import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.cache.ObjectMap;
import com.raplix.util.logger.Logger;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Iterator;

public class ReferenceObjectMap
implements ObjectMap {
    public static final int MAX_POLL_QTY = 50;
    private HashMap objectTable = new HashMap();
    private HashMap referenceTable = new HashMap();
    private ReferenceQueue referenceQueue = new ReferenceQueue();

    public Object find(ObjectID inObjectID) {
        Object obj = this.objectTable.get(inObjectID);
        return obj != null ? ((Reference)obj).get() : null;
    }

    public void clear() {
        this.objectTable.clear();
        this.referenceTable.clear();
    }

    public void remove(ObjectID inObjectID) {
        this.referenceTable.remove(this.objectTable.remove(inObjectID));
        this.pollQueue();
    }

    public void update(Object inObject, ObjectID inObjectID) {
        Reference ref = this.createJavaReference(inObject, this.referenceQueue);
        Reference oldRef = this.objectTable.put(inObjectID, ref);
        if (oldRef != null) {
            this.referenceTable.remove(oldRef);
        }
        this.referenceTable.put(ref, inObjectID);
    }

    public int size() {
        return this.objectTable.size();
    }

    private void pollQueue() {
        Reference ref;
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Polling ref:", this);
        }
        for (int i = 0; (ref = this.referenceQueue.poll()) != null && i < 50; ++i) {
            Object objectID;
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("polled ref:" + ref, this);
            }
            if (this.objectTable.get(objectID = this.referenceTable.get(ref)) == ref) {
                this.objectTable.remove(objectID);
            }
            this.referenceTable.remove(ref);
        }
    }

    public Iterator values() {
        return new MapIterator(this.objectTable.values().iterator());
    }

    protected Reference createJavaReference(Object inObject, ReferenceQueue inQueue) {
        return new SoftReference<Object>(inObject, inQueue);
    }

    private static class MapIterator
    implements Iterator {
        private Iterator iterator;

        MapIterator(Iterator baseIterator) {
            this.iterator = baseIterator;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            return ((Reference)this.iterator.next()).get();
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

