/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.cache;

import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.cache.GlobalObjectCache;
import com.raplix.rolloutexpress.persist.cache.TransactionObjectCache;
import com.raplix.rolloutexpress.persist.map.ClassMap;
import com.raplix.rolloutexpress.persist.map.exception.ClassMapException;
import com.raplix.util.logger.Logger;
import java.util.HashSet;
import java.util.Iterator;

public final class ObjectCache {
    private ThreadLocal transactionCaches = new ThreadLocal(){

        public Object get() {
            Object result = super.get();
            if (result == null) {
                result = new TransactionObjectCache(ObjectCache.this.mClassMap);
                this.set(result);
            }
            return result;
        }
    };
    private static ThreadLocal usedCaches = new ThreadLocal(){

        public Object get() {
            Object result = super.get();
            if (result == null) {
                result = new HashSet();
                this.set(result);
            }
            return result;
        }
    };
    private GlobalObjectCache globalCache;
    private ClassMap mClassMap;

    public ObjectCache(ClassMap inClassMap) {
        this.mClassMap = inClassMap;
        this.globalCache = new GlobalObjectCache(inClassMap);
    }

    public PersistentBean findObject(ObjectID inObjectID) {
        TransactionObjectCache cache = this.transactionCache();
        if (cache.isDirty(inObjectID)) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("dirty objID:" + inObjectID, this);
            }
            return cache.findObject(inObjectID);
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("clean objID:" + inObjectID, this);
        }
        return this.globalCache.findObject(inObjectID);
    }

    PersistentBean findCleanObject(ObjectID inObjectID) {
        TransactionObjectCache cache = this.transactionCache();
        if (cache.isDirty(inObjectID)) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("dirty objID:" + inObjectID, this);
            }
            return null;
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("clean objID:" + inObjectID, this);
        }
        return this.globalCache.findObject(inObjectID);
    }

    public void updateObject(PersistentBean inObject, int inFlushCount) throws ClassMapException {
        TransactionObjectCache cache = this.transactionCache();
        if (cache.isDirty(this.mClassMap.getBeanManager().getObjectID(inObject))) {
            cache.updateObject(inObject, inFlushCount);
        } else {
            this.globalCache.updateObject(inObject, inFlushCount, true);
        }
    }

    public void updateObject(PersistentBean[] inObjects, int inFlushCount) throws ClassMapException {
        TransactionObjectCache cache = this.transactionCache();
        for (int i = 0; i < inObjects.length; ++i) {
            if (cache.isDirty(this.mClassMap.getBeanManager().getObjectID(inObjects[i]))) {
                cache.updateObject(inObjects[i], inFlushCount);
                continue;
            }
            this.globalCache.updateObject(inObjects[i], inFlushCount, true);
        }
    }

    public void invalidateEntireCache() {
        this.transactionCache().invalidateEntireCache();
    }

    protected void reconcileCaches(boolean transactionSucceeded) throws ClassMapException {
        TransactionObjectCache cache = this.transactionCache();
        if (transactionSucceeded) {
            cache.reconcileWithGlobalCache(this.globalCache);
        }
        cache.init();
    }

    public static void transactionComplete(boolean success) throws ClassMapException {
        HashSet caches = (HashSet)usedCaches.get();
        if (Logger.isDebugEnabled(ObjectCache.class)) {
            Logger.debug("transactionComplete:" + success + ":caches:" + caches, ObjectCache.class);
        }
        Iterator iter = caches.iterator();
        while (iter.hasNext()) {
            ((ObjectCache)iter.next()).reconcileCaches(success);
        }
        caches.clear();
    }

    public int getFlushCount() {
        return this.globalCache.getFlushCount();
    }

    public void removeObject(ObjectID inObjectID) {
        this.transactionCache().removeObject(inObjectID);
    }

    public TransactionObjectCache transactionCache() {
        ((HashSet)usedCaches.get()).add(this);
        return (TransactionObjectCache)this.transactionCaches.get();
    }

    public GlobalObjectCache globalCache() {
        return this.globalCache;
    }

    public String toString() {
        return "ObjectCache:" + this.mClassMap;
    }
}

