/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.cache;

import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.cache.CacheUpdateListener;
import com.raplix.rolloutexpress.persist.cache.CacheUpdateListenerGroup;
import com.raplix.rolloutexpress.persist.cache.ObjectMap;
import com.raplix.rolloutexpress.persist.cache.ReferenceObjectMap;
import com.raplix.rolloutexpress.persist.map.ClassMap;
import com.raplix.rolloutexpress.persist.map.exception.ClassMapException;
import com.raplix.util.logger.Logger;

public final class GlobalObjectCache {
    private CacheUpdateListenerGroup mListeners = new CacheUpdateListenerGroup();
    private ClassMap mClassMap;
    private volatile int mFlushCount = 0;
    private ObjectMap objectMap;
    private volatile long mHits = 0L;
    private volatile long mMiss = 0L;

    public GlobalObjectCache(ClassMap inClassMap) {
        this.mClassMap = inClassMap;
        this.objectMap = new ReferenceObjectMap();
    }

    public void addListener(CacheUpdateListener listener) {
        this.mListeners.addListener(listener);
    }

    public int getFlushCount() {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("getFlushCount():" + this, this);
        }
        return this.mFlushCount;
    }

    synchronized PersistentBean findObject(ObjectID inObjectID) {
        PersistentBean obj = (PersistentBean)this.objectMap.find(inObjectID);
        if (obj == null) {
            ++this.mMiss;
        } else {
            ++this.mHits;
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug(this.toString(), this);
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateObject(PersistentBean inObject, int inFlushCount, boolean inClone) throws ClassMapException {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("updObj:" + inObject + ":flsh:" + inFlushCount + ":clone:" + inClone + ":cacheFlsh:" + this.mFlushCount, this);
        }
        if (inObject == null) {
            return;
        }
        GlobalObjectCache globalObjectCache = this;
        synchronized (globalObjectCache) {
            if (inFlushCount != this.mFlushCount) {
                return;
            }
            ObjectID objID = this.mClassMap.getBeanManager().getObjectID(inObject);
            PersistentBean obj = (PersistentBean)this.objectMap.find(objID);
            if (obj == null || this.mClassMap.getBeanManager().getUpdateCount(obj) < this.mClassMap.getBeanManager().getUpdateCount(inObject)) {
                inObject = inClone ? this.mClassMap.cloneForCache(inObject) : inObject;
                this.objectMap.update(inObject, objID);
                this.mListeners.updateObject(objID, inObject);
            }
        }
    }

    synchronized void removeObject(ObjectID inObjectID) {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("removeObjGLB:" + inObjectID, this);
        }
        this.incrementFlushCount();
        this.objectMap.remove(inObjectID);
        this.mListeners.removeObject(inObjectID);
    }

    synchronized void invalidateEntireCache() {
        this.incrementFlushCount();
        this.objectMap.clear();
        this.mListeners.invalidateEntireCache();
    }

    private void incrementFlushCount() {
        this.mFlushCount = this.mFlushCount == Integer.MAX_VALUE ? 0 : ++this.mFlushCount;
    }

    public String toString() {
        return "GlobalCache:" + this.mClassMap.getClassName() + ":Hits:" + this.mHits + ":Miss:" + this.mMiss + ":FlushCnt:" + this.mFlushCount;
    }

    public double getHitRate() {
        long total = this.mHits + this.mMiss;
        return total == 0L ? 0.0 : (double)this.mHits / (double)total;
    }

    public long getHits() {
        return this.mHits;
    }

    public long getMiss() {
        return this.mMiss;
    }
}

