/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist.cache;

import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.cache.CacheKey;
import com.raplix.rolloutexpress.persist.cache.CacheUpdateListener;
import com.raplix.rolloutexpress.persist.cache.GlobalObjectCache;
import com.raplix.rolloutexpress.persist.cache.ObjectCache;
import com.raplix.rolloutexpress.persist.cache.SingleObjectCache;
import com.raplix.rolloutexpress.persist.map.exception.ClassMapException;
import com.raplix.util.logger.Logger;
import java.util.HashMap;

public abstract class CustomSingleObjectCache
implements SingleObjectCache {
    private ObjectCache mObjectCache;
    private HashMap mKeyToIDMap = new HashMap();
    private HashMap mIDToKeyMap = new HashMap();

    public CustomSingleObjectCache(ObjectCache objectCache) {
        this.mObjectCache = objectCache;
        objectCache.globalCache().addListener(new CacheUpdateListener(){

            public void updateObject(ObjectID objectID, PersistentBean inObject) {
                CustomSingleObjectCache.this.updateObject(objectID, inObject);
            }

            public void invalidateEntireCache() {
                CustomSingleObjectCache.this.invalidateEntireCache();
            }

            public void removeObject(ObjectID inObjectID) {
                CustomSingleObjectCache.this.removeObject(inObjectID);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistentBean findObject(CacheKey key) {
        GlobalObjectCache globalObjectCache = this.mObjectCache.globalCache();
        synchronized (globalObjectCache) {
            ObjectID id = (ObjectID)this.mKeyToIDMap.get(key);
            if (id == null) {
                return null;
            }
            return this.mObjectCache.findCleanObject(id);
        }
    }

    private void updateObject(ObjectID objectID, PersistentBean inObject) {
        block3: {
            this.removeObject(objectID);
            try {
                CacheKey key = this.createKey(inObject);
                if (key != null) {
                    this.mKeyToIDMap.put(key, objectID);
                    this.mIDToKeyMap.put(objectID, key);
                }
            }
            catch (ClassMapException e) {
                if (!Logger.isDebugEnabled(this)) break block3;
                Logger.debug("error creating key, object " + objectID + " not cached", e, this);
            }
        }
    }

    protected abstract CacheKey createKey(PersistentBean var1) throws ClassMapException;

    private void invalidateEntireCache() {
        this.mKeyToIDMap.clear();
        this.mIDToKeyMap.clear();
    }

    private void removeObject(ObjectID inObjectID) {
        Object oldKey = this.mIDToKeyMap.remove(inObjectID);
        if (oldKey != null) {
            this.mKeyToIDMap.remove(oldKey);
        }
    }

    public String toString() {
        return this.mObjectCache.toString() + ":" + this.getName();
    }
}

